/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.meeting.demo;

import de.intarsys.cloudsuite.meeting.core.AbstractMessage;
import de.intarsys.cloudsuite.meeting.core.ConnectOptionsMeeting;
import de.intarsys.cloudsuite.meeting.core.ConnectOptionsParticipant;
import de.intarsys.cloudsuite.meeting.core.CtrlMeeting;
import de.intarsys.cloudsuite.meeting.core.MeetingInfo;
import de.intarsys.cloudsuite.meeting.core.MessageClose;
import de.intarsys.cloudsuite.meeting.core.MessageEvent;
import de.intarsys.cloudsuite.meeting.core.MessageProceed;
import de.intarsys.cloudsuite.meeting.core.ParticipantInfo;
import de.intarsys.tools.functor.IArgs;
import java.util.concurrent.CompletableFuture;

public class MeetingStub {
    private final CtrlMeeting hub;
    private boolean connected = false;
    private final ParticipantInfo participantInfo;
    private final MeetingInfo meetingInfo;

    public MeetingStub(CtrlMeeting hub, String meetingId, String participantId) {
        this.hub = hub;
        this.meetingInfo = this.createMeetingInfo(meetingId);
        this.participantInfo = this.createParticipantInfo(participantId);
    }

    public Object call(String method, IArgs args) throws Exception {
        return this.hub.call(this.meetingInfo, this.participantInfo, method, args);
    }

    public ConnectOptionsMeeting connect() {
        ConnectOptionsParticipant optionsParticipant = new ConnectOptionsParticipant();
        ConnectOptionsMeeting optionsMeeting = this.hub.connect(this.meetingInfo, this.participantInfo, optionsParticipant);
        this.connected = true;
        CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                MeetingStub.this.messageLoop(MeetingStub.this.meetingInfo, MeetingStub.this.participantInfo);
            }
        });
        return optionsMeeting;
    }

    protected MeetingInfo createMeetingInfo(String id) {
        MeetingInfo result = new MeetingInfo(id);
        return result;
    }

    protected ParticipantInfo createParticipantInfo(String id) {
        ParticipantInfo result = new ParticipantInfo(id);
        return result;
    }

    protected void messageLoop(MeetingInfo meetingInfo, ParticipantInfo participantInfo) {
        while (this.connected) {
            AbstractMessage msg = this.hub.fetchMessage(meetingInfo, participantInfo);
            this.processMessage(msg);
        }
    }

    protected void processMessage(AbstractMessage message) {
        if (message instanceof MessageEvent) {
            MessageEvent messageEvent = (MessageEvent)message;
        }
        if (message instanceof MessageProceed) {
            // empty if block
        }
        if (message instanceof MessageClose) {
            this.connected = false;
        }
    }
}

