/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.meeting.impl;

import de.intarsys.cloudsuite.meeting.core.IMeeting;
import de.intarsys.cloudsuite.meeting.core.IMeetingBin;
import de.intarsys.cloudsuite.meeting.core.IMeetingFactory;
import de.intarsys.cloudsuite.meeting.core.IMeetingHandler;
import de.intarsys.cloudsuite.meeting.core.IMeetingRegistry;
import de.intarsys.cloudsuite.meeting.impl.Meeting;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.component.IDisposable;
import de.intarsys.tools.conversation.ConversationRegistry;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.functor.IArgs;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversationMeetingFactory
implements IMeetingFactory,
IMeetingRegistry,
IMeetingBin {
    private static final Attribute ATTR_MEETING = new Attribute("meeting");
    private static final Attribute ATTR_MEETING_FINALIZER = new Attribute("meetingFinalizer");
    private static final Logger Log = LoggerFactory.getLogger(ConversationMeetingFactory.class);
    private long participantTimeout = 60L;
    private AtomicInteger counter = new AtomicInteger();

    protected static Meeting get(IAttributeSupport as) {
        if (as == null) {
            return null;
        }
        return (Meeting)as.getAttribute((Object)ATTR_MEETING);
    }

    protected static void set(IAttributeSupport as, final Meeting value) {
        if (as == null) {
            return;
        }
        as.setAttribute((Object)ATTR_MEETING, (Object)value);
        as.setAttribute((Object)ATTR_MEETING_FINALIZER, (Object)new IDisposable(){

            public void dispose() {
                value.unregistered();
            }
        });
    }

    @Override
    public IMeeting createMeeting(IMeetingHandler meetingHandler, IArgs args) {
        Conversation conversation = new Conversation("MeetingConversation");
        args.put("id", (Object)conversation.getHandle());
        Meeting meeting = new Meeting(this, meetingHandler, args);
        meeting.setParticipantTimeout(this.getParticipantTimeout());
        ConversationMeetingFactory.set((IAttributeSupport)conversation, meeting);
        ConversationRegistry.get().publish((IConversation)conversation);
        int count = this.counter.incrementAndGet();
        Log.debug("{} meeting created, {} active", (Object)this, (Object)count);
        return meeting;
    }

    @Override
    public void disposeMeeting(IMeeting meeting) {
        try {
            IConversation conversation = ConversationRegistry.get().getConversation(meeting.getId());
            ConversationRegistry.get().unpublish(conversation);
        }
        catch (Exception conversation) {
            // empty catch block
        }
        int count = this.counter.decrementAndGet();
        Log.debug("{} meeting disposed, {} active", (Object)this, (Object)count);
    }

    public long getParticipantTimeout() {
        return this.participantTimeout;
    }

    @Override
    public IMeeting lookupMeeting(String id) {
        try {
            IConversation conversation = ConversationRegistry.get().getConversation(id);
            return ConversationMeetingFactory.get((IAttributeSupport)conversation);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setParticipantTimeout(long participantTimeout) {
        this.participantTimeout = participantTimeout;
    }
}

