/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.meeting.impl;

import de.intarsys.cloudsuite.meeting.core.AbstractMessage;
import de.intarsys.cloudsuite.meeting.core.ConnectOptionsMeeting;
import de.intarsys.cloudsuite.meeting.core.ConnectOptionsParticipant;
import de.intarsys.cloudsuite.meeting.core.IMeeting;
import de.intarsys.cloudsuite.meeting.core.IMeetingBin;
import de.intarsys.cloudsuite.meeting.core.IMeetingHandler;
import de.intarsys.cloudsuite.meeting.core.IMessageChannel;
import de.intarsys.cloudsuite.meeting.core.IParticipant;
import de.intarsys.cloudsuite.meeting.core.ParticipantInfo;
import de.intarsys.cloudsuite.meeting.impl.MeetingState;
import de.intarsys.cloudsuite.meeting.impl.MeetingTools;
import de.intarsys.cloudsuite.meeting.impl.Participant;
import de.intarsys.tools.concurrent.ThreadTools;
import de.intarsys.tools.exception.InvalidRequestException;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.string.StringTools;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Meeting
implements IMeeting {
    public static final int DEFAULT_PARTICIPANT_TIMEOUT = 60;
    private static final Logger Log = LoggerFactory.getLogger(Meeting.class);
    private static final Logger PLANT = LoggerFactory.getLogger((String)"plant");
    protected static ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(ThreadTools.newThreadFactoryDaemon((String)"Meeting"));
    private final String id;
    private MeetingState state = MeetingState.WaitConnect;
    private final IMeetingHandler handler;
    private final List<IParticipant> participants = new CopyOnWriteArrayList<IParticipant>();
    private long participantTimeout = 60L;
    private final Runnable participantTimeoutCommand = new Runnable(){

        @Override
        public void run() {
            Meeting.this.onConnectTimeout();
        }
    };
    private final Runnable aliveCheckCommand = new Runnable(){

        @Override
        public void run() {
            Meeting.this.onAliveCheck();
        }
    };
    private Future participantTimeoutFuture;
    private Future aliveCheckFuture;
    private final IMeetingBin meetingBin;
    private final IArgs args;
    private volatile int msgCounter = 0;

    public Meeting(IMeetingBin meetingBin, IMeetingHandler handler, IArgs args) {
        String tmpId;
        this.meetingBin = meetingBin;
        this.id = tmpId = (String)ArgTools.get((IArgs)args, (String)"id", String.class, () -> UUID.randomUUID().toString());
        this.args = args;
        this.handler = handler;
        long timeout = 30000L;
        this.aliveCheckFuture = scheduler.scheduleWithFixedDelay(this.aliveCheckCommand, timeout, timeout, TimeUnit.MILLISECONDS);
        this.init();
    }

    public void addParticpant(IParticipant participant) {
        this.participants.add(participant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call(IParticipant participant, String method, IArgs args) throws Exception {
        Meeting meeting = this;
        synchronized (meeting) {
            if (this.isStateClosed()) {
                throw new InvalidRequestException("meeting '" + this.getId() + "' invalid state " + this.getState().name());
            }
        }
        int i = this.logPlantRequest(participant.getId(), this.getId(), "call '" + method + "'");
        Object result = this.getHandler().call(this, participant, method, args);
        this.logPlantResponse(i, participant.getId(), this.getId(), StringTools.safeString((Object)result));
        return result;
    }

    protected void checkDispose() {
        if (this.isStateClosed() && this.getParticipants().size() == 0) {
            Log.debug("{} gets disposed", (Object)this);
            this.meetingBin.disposeMeeting(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkWaitConnect() {
        Meeting meeting = this;
        synchronized (meeting) {
            if (this.isStateWaitConnect()) {
                if (this.participantTimeoutFuture == null) {
                    this.participantTimeoutFuture = scheduler.schedule(this.participantTimeoutCommand, this.getParticipantTimeout(), TimeUnit.SECONDS);
                }
            } else if (this.participantTimeoutFuture != null) {
                this.participantTimeoutFuture.cancel(true);
                this.participantTimeoutFuture = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Meeting meeting = this;
        synchronized (meeting) {
            if (this.isStateClosed()) {
                return;
            }
            for (IParticipant participant : this.participants) {
                ((Participant)participant).close();
            }
            this.aliveCheckFuture.cancel(false);
            this.toStateClosed();
            this.getHandler().onClosed(this);
            this.checkDispose();
        }
        this.logPlantRequest(this.getId(), this.getId(), "close");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectOptionsMeeting connect(ParticipantInfo participantInfo, ConnectOptionsParticipant options) {
        String target = this.getDebugOptionString("connect.participant");
        if (StringTools.isEmpty((String)target) || participantInfo.getId().matches(target)) {
            int millis = this.getDebugOptionInt("connect.error.throw.after");
            if (millis > 0) {
                ThreadTools.sleep((long)millis);
                throw new RuntimeException("force failed");
            }
            millis = this.getDebugOptionInt("connect.error.schedule.after");
            if (millis > 0) {
                scheduler.schedule(() -> this.error("fail", "force failed"), (long)millis, TimeUnit.MILLISECONDS);
            }
        }
        IMessageChannel messageChannel = MeetingTools.getMessageChannel(options);
        Meeting meeting = this;
        synchronized (meeting) {
            if (this.isStateClosed()) {
                throw new InvalidRequestException("meeting '" + this.getId() + "' closed, cannot connect");
            }
            IParticipant participant = this.createParticipant(participantInfo.getId(), messageChannel);
            this.logPlantRequest(participant.getId(), this.getId(), "connect");
            this.getHandler().onConnect(this, participant);
            this.checkWaitConnect();
        }
        return new ConnectOptionsMeeting();
    }

    protected IParticipant createParticipant(String id, IMessageChannel messageChannel) {
        if (this.lookupParticipant(id) != null) {
            throw new IllegalArgumentException("duplicate participant '" + id + "'");
        }
        return new Participant(id, messageChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(IParticipant participant) {
        Meeting meeting = this;
        synchronized (meeting) {
            this.logPlantRequest(participant.getId(), this.getId(), "disconnect");
            this.removeParticipant(participant);
            ((Participant)participant).close();
            this.getHandler().onDisconnected(this, participant);
            this.checkDispose();
            this.checkWaitConnect();
        }
    }

    protected void error(String code, String message) {
        this.getHandler().onError(this, code, message);
    }

    @Override
    public AbstractMessage fetchMessage(IParticipant participant) {
        int i = this.logPlantRequest(participant.getId(), this.getId(), "fetch");
        try {
            String target = this.getDebugOptionString("fetch.participant");
            if (StringTools.isEmpty((String)target) || participant.getId().matches(target)) {
                int millis = this.getDebugOptionInt("fetch.error.throw.after");
                if (millis > 0) {
                    ThreadTools.sleep((long)millis);
                    throw new RuntimeException("force failed");
                }
                millis = this.getDebugOptionInt("fetch.error.schedule.after");
                if (millis > 0) {
                    scheduler.schedule(() -> this.error("fail", "force failed"), (long)millis, TimeUnit.MILLISECONDS);
                }
            }
            AbstractMessage msg = ((Participant)participant).fetchMessage(this);
            this.logPlantResponse(i, participant.getId(), this.getId(), msg);
            return msg;
        }
        catch (RuntimeException e) {
            this.logPlantResponse(i, participant.getId(), this.getId(), "*** fetch failed");
            throw e;
        }
    }

    public IArgs getArgs() {
        return this.args;
    }

    protected int getDebugOptionInt(String option) {
        return ArgTools.getInt((IArgs)this.getArgs(), (String)("debug." + option), (int)0);
    }

    protected String getDebugOptionString(String option) {
        return ArgTools.getString((IArgs)this.getArgs(), (String)("debug." + option), null);
    }

    public IMeetingHandler getHandler() {
        return this.handler;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<IParticipant> getParticipants() {
        return this.participants;
    }

    public long getParticipantTimeout() {
        return this.participantTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MeetingState getState() {
        Meeting meeting = this;
        synchronized (meeting) {
            return this.state;
        }
    }

    protected void init() {
        this.setParticipantTimeout(ArgTools.getLongStrict((IArgs)this.getArgs(), (String)"participantTimeout", (long)this.getParticipantTimeout()));
    }

    @Override
    public boolean isStateClosed() {
        return this.getState() == MeetingState.Closed;
    }

    @Override
    public boolean isStateConnected() {
        return this.getState() == MeetingState.Connected;
    }

    @Override
    public boolean isStateWaitConnect() {
        return this.getState() == MeetingState.WaitConnect;
    }

    protected String logPlantConvert(Object sender) {
        String result = StringTools.safeString((Object)sender);
        result = result.replace("-", "_");
        result = result.replace("\n", " ");
        result = result.replace("\r", " ");
        return result;
    }

    protected int logPlantRequest(Object sender, Object receiver, Object method) {
        int msgId = this.msgCounter++;
        PLANT.debug("{} \t\t->\t\t{} \t\t: [{}] {} ", new Object[]{this.logPlantConvert(sender), this.logPlantConvert(receiver), this.logPlantConvert(msgId), this.logPlantConvert(method)});
        return msgId;
    }

    protected void logPlantResponse(int msgId, Object sender, Object receiver, Object result) {
        PLANT.debug("{} \t\t<--\t\t{} \t\t: [{}] {} ", new Object[]{this.logPlantConvert(sender), this.logPlantConvert(receiver), this.logPlantConvert(msgId), this.logPlantConvert(result)});
    }

    @Override
    public IParticipant lookupParticipant(String id) {
        if (id == null) {
            return null;
        }
        return this.participants.stream().filter(p -> id.equals(p.getId())).findFirst().orElse(null);
    }

    protected void onAliveCheck() {
        for (IParticipant participant : this.participants) {
            if (((Participant)participant).isAlive()) continue;
            Log.debug("{} participant {} alive timeout", (Object)this, (Object)participant.getId());
            this.disconnect(participant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onConnectTimeout() {
        Log.debug("{} connect timeout", (Object)this);
        Meeting meeting = this;
        synchronized (meeting) {
            this.participantTimeoutFuture = null;
            this.error("ConnectTimeout", "not all required participants connected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postEvent(String event, IArgs args) {
        Meeting meeting = this;
        synchronized (meeting) {
            if (this.isStateClosed()) {
                throw new InvalidRequestException("meeting '" + this.getId() + "' invalid state " + this.getState().name());
            }
        }
        for (IParticipant participant : this.participants) {
            this.logPlantRequest(this.getId(), participant.getId(), "post '" + event + "'");
            ((Participant)participant).postEvent(this, event, args);
        }
    }

    public void removeParticipant(IParticipant participant) {
        this.participants.remove(participant);
    }

    public void setParticipantTimeout(long connectTimeout) {
        this.participantTimeout = connectTimeout;
    }

    protected void setState(MeetingState state) {
        this.state = state;
    }

    protected void toStateClosed() {
        this.setState(MeetingState.Closed);
    }

    @Override
    public void toStateConnected() {
        if (this.isStateClosed()) {
            throw new InvalidRequestException("meeting '" + this.getId() + "' closed");
        }
        this.setState(MeetingState.Connected);
    }

    @Override
    public void toStateWaitConnect() {
        if (this.isStateClosed()) {
            return;
        }
        this.setState(MeetingState.WaitConnect);
    }

    public String toString() {
        return "Meeting " + this.getId();
    }

    public void unregistered() {
        this.getHandler().onUnregistered(this);
    }
}

