/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.meeting.impl;

import de.intarsys.cloudsuite.meeting.core.AbstractMessage;
import de.intarsys.cloudsuite.meeting.core.IMeeting;
import de.intarsys.cloudsuite.meeting.core.IMessageChannel;
import de.intarsys.cloudsuite.meeting.core.IParticipant;
import de.intarsys.cloudsuite.meeting.impl.Meeting;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.lang.LangTools;

public class Participant
implements IParticipant {
    public static final long ALIVE_TIMEOUT = 60000L;
    private final String id;
    private final IMessageChannel messageChannel;
    private boolean closed = false;
    private long touched = -1L;

    public Participant(String id, IMessageChannel messageChannel) {
        this.id = id;
        this.messageChannel = messageChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        Participant participant = this;
        synchronized (participant) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.messageChannel.close();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Participant) {
            return LangTools.equals((Object)this.id, (Object)((Participant)obj).id);
        }
        return super.equals(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractMessage fetchMessage(Meeting meeting) {
        if (this.messageChannel.isDrained()) {
            return IMessageChannel.MSG_CLOSE;
        }
        Participant participant = this;
        synchronized (participant) {
            this.touched = -1L;
        }
        AbstractMessage msg = this.messageChannel.poll();
        Participant participant2 = this;
        synchronized (participant2) {
            this.touched = System.currentTimeMillis();
        }
        return msg;
    }

    @Override
    public String getId() {
        return this.id;
    }

    protected IMessageChannel getMessageChannel() {
        return this.messageChannel;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlive() {
        Participant participant = this;
        synchronized (participant) {
            return this.touched == -1L || System.currentTimeMillis() - this.touched < 60000L;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postEvent(IMeeting meeting, String name, IArgs args) {
        Participant participant = this;
        synchronized (participant) {
            if (this.closed) {
                return;
            }
        }
        this.messageChannel.post(name, args);
    }

    public String toString() {
        return "Participant " + this.getId();
    }
}

