/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.meeting.impl;

import de.intarsys.cloudsuite.meeting.core.AbstractMessage;
import de.intarsys.cloudsuite.meeting.core.IMessageChannel;
import de.intarsys.cloudsuite.meeting.core.MessageEvent;
import de.intarsys.tools.functor.IArgs;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueuedMessageChannel
implements IMessageChannel {
    private static final int MAX_MESSAGES = 1000;
    public static final String ARG_MESSAGETIMEOUT = "messageTimeout";
    public static final int DEFAULT_KEEPALIVE = 50;
    private static final Logger Log = LoggerFactory.getLogger(QueuedMessageChannel.class);
    private String logLabel = this.toString();
    private int maxQueueSize = 1;
    private int keepAlive = 50;
    private final BlockingQueue<AbstractMessage> queue = new LinkedBlockingQueue<AbstractMessage>(1000);
    private volatile boolean drained = false;

    @Override
    public void close() {
        this.queueOffer(IMessageChannel.MSG_CLOSE);
    }

    public int getKeepAlive() {
        return this.keepAlive;
    }

    public String getLogLabel() {
        return this.logLabel;
    }

    @Override
    public boolean isDrained() {
        return this.drained;
    }

    @Override
    public AbstractMessage poll() {
        AbstractMessage msg;
        try {
            msg = this.queue.poll(this.getKeepAlive(), TimeUnit.SECONDS);
            if (msg == null) {
                msg = IMessageChannel.MSG_PROCEED;
            }
        }
        catch (InterruptedException ex) {
            Log.info("{} message queue interrupted", (Object)this.getLogLabel());
            Thread.currentThread().interrupt();
            msg = IMessageChannel.MSG_CLOSE;
        }
        this.drained = msg == IMessageChannel.MSG_CLOSE;
        return msg;
    }

    @Override
    public MessageEvent post(String name, IArgs args) {
        MessageEvent msg = new MessageEvent(name, args);
        this.queueOffer(msg);
        return msg;
    }

    protected AbstractMessage queueOffer(AbstractMessage msg) {
        while (!this.queue.offer(msg)) {
            this.queue.poll();
            Log.warn("{} queue discarded message", (Object)this.getLogLabel());
        }
        int currentSize = this.queue.size();
        if (currentSize > this.maxQueueSize) {
            this.maxQueueSize = currentSize;
            Log.debug("{} queue new max size {}", (Object)this.getLogLabel(), (Object)this.maxQueueSize);
        }
        return msg;
    }

    public void setKeepAlive(int messageTimeout) {
        this.keepAlive = messageTimeout;
    }

    public void setLogLabel(String logLabel) {
        this.logLabel = logLabel;
    }
}

