/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.meeting.service;

import de.intarsys.cloudsuite.meeting.core.AbstractMessage;
import de.intarsys.cloudsuite.meeting.core.ConnectOptionsMeeting;
import de.intarsys.cloudsuite.meeting.core.CtrlMeeting;
import de.intarsys.cloudsuite.meeting.service.RequestCall;
import de.intarsys.cloudsuite.meeting.service.RequestConnect;
import de.intarsys.cloudsuite.meeting.service.RequestDisconnect;
import de.intarsys.cloudsuite.meeting.service.RequestFetchMessage;
import de.intarsys.cloudsuite.meeting.service.RequestTest;
import de.intarsys.cloudsuite.meeting.service.ResponseTest;
import de.intarsys.tools.jaxrs.ServiceImplementor;
import de.intarsys.tools.jaxrs.Stateful;
import de.intarsys.tools.loadbalance.LoadBalanced;
import de.intarsys.tools.zones.Zone;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.concurrent.ForkJoinPool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/v1/meeting")
@Component
@ServiceImplementor
public class SvcMeeting {
    @Autowired
    private CtrlMeeting ctrlMeeting;

    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @POST
    @Path(value="/call")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Object call(RequestCall request) throws Exception {
        return this.ctrlMeeting.call(request.getMeetingInfo(), request.getParticipantInfo(), request.getName(), request.getArgs());
    }

    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @POST
    @Path(value="/connect")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ConnectOptionsMeeting connect(RequestConnect request) throws Exception {
        return this.ctrlMeeting.connect(request.getMeetingInfo(), request.getParticipantInfo(), request.getOptions());
    }

    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @POST
    @Path(value="/disconnect")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void disconnect(RequestDisconnect request) throws Exception {
        this.ctrlMeeting.disconnect(request.getMeetingInfo(), request.getParticipantInfo());
    }

    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @POST
    @Path(value="/fetchMessageAsync")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void fetchMessageAsync(RequestFetchMessage request, @Suspended AsyncResponse asyncResponse) throws Exception {
        Runnable task = Zone.getCurrent().wrap(() -> {
            AbstractMessage msg = this.ctrlMeeting.fetchMessage(request.getMeetingInfo(), request.getParticipantInfo());
            asyncResponse.resume((Object)msg);
        });
        ForkJoinPool.commonPool().execute(task);
    }

    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @POST
    @Path(value="/fetchMessage")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public AbstractMessage fetchMessageSync(RequestFetchMessage request) throws Exception {
        return this.ctrlMeeting.fetchMessage(request.getMeetingInfo(), request.getParticipantInfo());
    }

    @POST
    @Path(value="/test")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ResponseTest test(RequestTest request) throws Exception {
        ResponseTest response = new ResponseTest();
        response.setReply("request received");
        return response;
    }
}

