/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.module.ais;

import de.intarsys.security.device.ais.common.AisEnvironment;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.exception.InitializationException;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;
import java.io.InputStream;
import java.security.KeyStore;

public class AisEnvironmentInitializer {
    private String rasBaseUri;
    private String serviceAddress;
    private String customerName;
    private String clientKeyStorePath;
    private String clientKeyStoreType;
    private String clientKeyStorePassword;
    private String clientKeyPassword;

    public String getClientKeyPassword() {
        return this.clientKeyPassword;
    }

    public KeyStore getClientKeyStore() throws Exception {
        if (StringTools.isEmpty((String)this.getClientKeyStorePath())) {
            return null;
        }
        ILocator locator = LocatorTools.createLocator((Object)this.getClientKeyStorePath(), null, null);
        try (InputStream is = locator.getInputStream();){
            KeyStore keyStore = KeyStore.getInstance(this.getClientKeyStoreType());
            keyStore.load(is, StringTools.isEmpty((String)this.getClientKeyStorePassword()) ? null : this.getClientKeyStorePassword().toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
    }

    public String getClientKeyStorePassword() {
        return this.clientKeyStorePassword;
    }

    public String getClientKeyStorePath() {
        return this.clientKeyStorePath;
    }

    public String getClientKeyStoreType() {
        return this.clientKeyStoreType;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public String getRasBaseUri() {
        return this.rasBaseUri;
    }

    public String getServiceAddress() {
        return this.serviceAddress;
    }

    @PostConstruct
    public void init() {
        try {
            AisEnvironment aisEnvironment = AisEnvironment.get();
            aisEnvironment.setCustomerName(this.getCustomerName());
            aisEnvironment.setRasBaseUri(this.getRasBaseUri());
            aisEnvironment.setServiceAddress(this.getServiceAddress());
            aisEnvironment.setSslClientCert(this.getClientKeyStore());
            if (this.getClientKeyPassword() != null) {
                aisEnvironment.setSslClientCertPassword(Secret.hide((char[])this.getClientKeyPassword().toCharArray()));
            }
        }
        catch (Exception e) {
            throw new InitializationException((Throwable)e);
        }
    }

    public void setClientKeyPassword(String clientKeyPassword) {
        this.clientKeyPassword = clientKeyPassword;
    }

    public void setClientKeyStorePassword(String clientKeystorePassword) {
        this.clientKeyStorePassword = clientKeystorePassword;
    }

    public void setClientKeyStorePath(String clientKeystorePath) {
        this.clientKeyStorePath = clientKeystorePath;
    }

    public void setClientKeyStoreType(String clientKeystoreType) {
        this.clientKeyStoreType = clientKeystoreType;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public void setRasBaseUri(String rasBaseUri) {
        this.rasBaseUri = rasBaseUri;
    }

    public void setServiceAddress(String serviceAddress) {
        this.serviceAddress = serviceAddress;
    }
}

