/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.function;

import tec.units.ri.AbstractConverter;
import tec.units.ri.function.LogConverter;
import tec.units.ri.internal.MathUtil;
import tec.uom.lib.common.function.ValueSupplier;

public final class ExpConverter
extends AbstractConverter
implements ValueSupplier<String> {
    private double base;
    private double logOfBase;

    public ExpConverter(double base) {
        this.base = base;
        this.logOfBase = MathUtil.log(base);
    }

    public double getBase() {
        return this.base;
    }

    @Override
    public AbstractConverter inverse() {
        return new LogConverter(this.base);
    }

    public final String toString() {
        if (this.base == Math.E) {
            return "e";
        }
        return "Exp(" + this.base + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ExpConverter)) {
            return false;
        }
        ExpConverter that = (ExpConverter)obj;
        return this.base == that.base;
    }

    @Override
    public int hashCode() {
        long bits = Double.doubleToLongBits(this.base);
        return (int)(bits ^ bits >>> 32);
    }

    @Override
    public double convert(double amount) {
        return MathUtil.exp(this.logOfBase * amount);
    }

    public boolean isLinear() {
        return false;
    }

    public String getValue() {
        return this.toString();
    }
}

