/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.function;

import javax.measure.UnitConverter;
import tec.units.ri.AbstractConverter;
import tec.uom.lib.common.function.ValueSupplier;

public final class MultiplyConverter
extends AbstractConverter
implements ValueSupplier<Double> {
    private double factor;

    public MultiplyConverter(double factor) {
        if (factor == 1.0) {
            throw new IllegalArgumentException("Would result in identity converter");
        }
        this.factor = factor;
    }

    public double getFactor() {
        return this.factor;
    }

    @Override
    public UnitConverter concatenate(UnitConverter converter) {
        if (!(converter instanceof MultiplyConverter)) {
            return super.concatenate(converter);
        }
        double newfactor = this.factor * ((MultiplyConverter)converter).factor;
        return newfactor == 1.0 ? IDENTITY : new MultiplyConverter(newfactor);
    }

    @Override
    public MultiplyConverter inverse() {
        return new MultiplyConverter(1.0 / this.factor);
    }

    @Override
    public double convert(double value) {
        return value * this.factor;
    }

    public final String toString() {
        return "MultiplyConverter(" + this.factor + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MultiplyConverter)) {
            return false;
        }
        MultiplyConverter that = (MultiplyConverter)obj;
        return this.factor == that.factor;
    }

    @Override
    public int hashCode() {
        long bits = Double.doubleToLongBits(this.factor);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean isLinear() {
        return true;
    }

    public Double getValue() {
        return this.factor;
    }
}

