/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.signature;

import de.intarsys.pdf.app.acroform.FormHandlerFactory;
import de.intarsys.pdf.app.appearance.AppearanceCreatorTools;
import de.intarsys.pdf.app.appearance.IAppearanceCreator;
import de.intarsys.pdf.cos.COSRuntimeException;
import de.intarsys.pdf.design.widget.IFieldDefinition;
import de.intarsys.pdf.design.widget.IFieldReference;
import de.intarsys.pdf.design.widget.NewFieldReference;
import de.intarsys.pdf.pd.PDAFSignatureField;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDBuildProperties;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.ISignatureContainerEntryProcessor;
import de.intarsys.security.method.common.signature.ISignatureContainerBuilder;
import de.intarsys.security.method.pdf.signature.IPDDocumentSignatureEncoder;
import de.intarsys.security.method.pdf.signature.IPDDocumentSigner;
import de.intarsys.security.method.pdf.signature.ISignatureModifier;
import de.intarsys.security.method.pdf.signature.PDDocumentSignerParameters;
import de.intarsys.security.method.pdf.signature.PDFSignatureContainer;
import de.intarsys.security.method.pdf.signature.PDFSignatureContainerEntry;
import de.intarsys.security.signature.ISignatureContainerEntry;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.monitor.Trace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class CommonPDDocumentSigner
implements IPDDocumentSigner {
    protected static final Logger Log = LoggerFactory.getLogger(CommonPDDocumentSigner.class);
    private PDBuildProperties buildProperties;
    private final IPDDocumentSignatureEncoder encoder;
    private final List<ISignatureContainerEntryProcessor> finalizer = new ArrayList<ISignatureContainerEntryProcessor>();

    protected CommonPDDocumentSigner(IPDDocumentSignatureEncoder encoder) {
        this.encoder = encoder;
    }

    public void addFinalizer(ISignatureContainerEntryProcessor processor) {
        this.finalizer.add(processor);
    }

    protected abstract PDSignature basicCreatePDSignature();

    protected void checkPermissions(PDDocument document) throws SecurityApplicationException {
    }

    protected PDSignature createPDSignature(PDDocument document, PDDocumentSignerParameters parameters) {
        PDAFSignatureField field = this.createPDSignatureAppearance(document, parameters);
        PDSignature pdSignature = this.basicCreatePDSignature();
        pdSignature.setBuildProperties(this.getBuildProperties());
        this.preparePDSignature(pdSignature, field, document, parameters);
        FormHandlerFactory.get().createFormHandler(document, null).setFieldValue((Object)field, (Object)pdSignature);
        return pdSignature;
    }

    protected PDAFSignatureField createPDSignatureAppearance(PDDocument document, PDDocumentSignerParameters parameters) {
        PDAFSignatureField field;
        IFieldDefinition fieldDefinition = parameters.getFieldDefinition();
        if (fieldDefinition != null) {
            PDAFSignatureField field2 = (PDAFSignatureField)fieldDefinition.getField();
            if (field2 == null) {
                throw new IllegalArgumentException("signature field '" + fieldDefinition.getFieldName() + "' doesn't exist");
            }
            return field2;
        }
        IFieldReference fieldReference = parameters.getFieldReference();
        if (fieldReference == null) {
            Log.debug("no field position set, creating invisible signature.");
            fieldReference = new NewFieldReference(document, "Sig");
        }
        if ((field = (PDAFSignatureField)fieldReference.getField()) == null) {
            throw new IllegalArgumentException("signature field '" + fieldReference.getFieldName() + "' doesn't exist");
        }
        if (parameters.getAppearanceCreator() != null && fieldReference.isVisible()) {
            AppearanceCreatorTools.setAppearanceCreator((PDObject)field, (IAppearanceCreator)parameters.getAppearanceCreator());
            AppearanceCreatorTools.createAppearance((PDAcroFormField)field);
        }
        return field;
    }

    protected PDFSignatureContainer documentSigned(PDDocument document, PDSignature pdSignature, ISignatureData signatureData) throws SecurityApplicationException, IOException {
        PDFSignatureContainer signatureContainer = PDFSignatureContainer.createSignatureContainer(document);
        PDFSignatureContainerEntry signature = signatureContainer.getEntry(pdSignature);
        this.doFinalize(signature, signatureData);
        if (document.isDirty()) {
            document.save();
        }
        return signatureContainer;
    }

    protected void doFinalize(ISignatureContainerEntry signature, ISignatureData signatureData) throws SecurityApplicationException, IOException {
        for (ISignatureContainerEntryProcessor processor : this.getFinalizer()) {
            processor.process((ISignatureContainerBuilder)this, signature, signatureData);
        }
    }

    protected void doModify(PDSignature pdSignature, List<ISignatureModifier> modifier) throws SecurityApplicationException {
        for (ISignatureModifier each : modifier) {
            each.modify(this, pdSignature);
        }
    }

    public PDBuildProperties getBuildProperties() {
        return this.buildProperties;
    }

    public IPDDocumentSignatureEncoder getEncoder() {
        return this.encoder;
    }

    public List<ISignatureContainerEntryProcessor> getFinalizer() {
        return new ArrayList<ISignatureContainerEntryProcessor>(this.finalizer);
    }

    protected PDSignature prepareDocument(PDDocument document, PDDocumentSignerParameters parameters) throws SecurityApplicationException {
        PDSignature pdSignature = this.createPDSignature(document, parameters);
        this.doModify(pdSignature, parameters.getModifier());
        this.getEncoder().initialize(document, pdSignature);
        return pdSignature;
    }

    protected void preparePDSignature(PDSignature pdSignature, PDAFSignatureField field, PDDocument document, PDDocumentSignerParameters parameters) {
    }

    protected void saveDocument(PDDocument document, ILocator destination) throws IOException {
        ILocator locator = destination == null ? document.getLocator() : destination;
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("saving document to '" + locator.getPath() + "'");
        }
        document.save(locator);
    }

    public void setBuildProperties(PDBuildProperties buildProperties) {
        this.buildProperties = buildProperties;
    }

    @Override
    public IConversation<PDFSignatureContainer> sign(PDDocument document, ILocator locator, PDDocumentSignerParameters parameters) {
        try {
            if (!parameters.isSkipPermissionCheck()) {
                this.checkPermissions(document);
            }
            PDSignature pdSignature = this.prepareDocument(document, parameters);
            Trace.get().sample(Level.DEBUG, "CommonPDDocumentSigner prepared");
            this.saveDocument(document, locator);
            Trace.get().sample(Level.DEBUG, "CommonPDDocumentSigner saved");
            IConversation<ISignatureData> conversation = this.getEncoder().getConversation();
            return conversation.thenApply(result -> this.documentSigned(document, pdSignature, (ISignatureData)result));
        }
        catch (COSRuntimeException e) {
            if (e.getCause() instanceof IOException) {
                return Conversation.failed((Throwable)((IOException)e.getCause()));
            }
            if (e.getCause() != null) {
                return Conversation.failed((Throwable)new IOException(e.getCause().getLocalizedMessage(), e.getCause()));
            }
            return Conversation.failed((Throwable)e);
        }
        catch (IOException e) {
            if (e.getCause() instanceof SecurityApplicationException) {
                return Conversation.failed((Throwable)((SecurityApplicationException)e.getCause()));
            }
            return Conversation.failed((Throwable)e);
        }
        catch (SecurityApplicationException e) {
            return Conversation.failed((Throwable)e);
        }
    }
}

