/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.signature;

import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.crypt.ISystemSecurityHandler;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.writer.COSWriter;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.method.cms.signature.CMSSignatureContainer;
import de.intarsys.security.method.cms.signature.ICMSSignatureContainerBuilder;
import de.intarsys.security.method.cms.validation.ResultValidationDataAppender;
import de.intarsys.security.method.common.signature.AdESSignerTools;
import de.intarsys.security.method.pdf.signature.AbstractStoreSignatureField;
import de.intarsys.security.method.pdf.signature.CommonPDDocumentSignatureEncoder;
import de.intarsys.security.method.pdf.signature.IStoreSignatureField;
import de.intarsys.security.method.pdf.signature.PDSignatureByteRange;
import de.intarsys.security.method.pdf.signature.StoreSignatureFieldEncoded;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.security.signature.common.ExtendedSignatureData;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.SignatureData;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;

public abstract class DSECMSBased
extends CommonPDDocumentSignatureEncoder {
    private final IFactory<ICMSSignatureContainerBuilder> cmsBuilderFactory;
    private final IArgs cmsBuilderArgs;
    private final IDigester digester;
    private IConversation conversation;

    public DSECMSBased(IFactory<ICMSSignatureContainerBuilder> factory, IArgs cmsSignerArgs) throws ObjectCreationException {
        this.digester = de.intarsys.security.digest.DigestTools.getDigester((IArgs)cmsSignerArgs, (String)"SHA-256");
        this.cmsBuilderFactory = factory;
        this.cmsBuilderArgs = cmsSignerArgs;
    }

    protected ISignatureData createResult(CMSSignatureContainer cmsSignature) throws IOException {
        ISignatureData result = null;
        byte[] encodedCms = LocatorTools.getBytes((ILocator)cmsSignature.getLocator());
        IExtendedValidationData validationData = ResultValidationDataAppender.getValidationData((ISignatureContainer)cmsSignature);
        result = validationData == null ? SignatureData.create((byte[])encodedCms) : ExtendedSignatureData.create((byte[])encodedCms, null, (IExtendedValidationData)validationData);
        return result;
    }

    @Override
    protected IStoreSignatureField createStoreSignatureField() {
        COSName filterName = AbstractStoreSignatureField.CN_ADOBE_PPKLITE;
        if (this.isECSignature()) {
            filterName = AbstractStoreSignatureField.CN_ADOBE_PPKMS;
        }
        StoreSignatureFieldCMSBased storeField = this.createStoreSignatureField(filterName);
        return storeField;
    }

    protected abstract StoreSignatureFieldCMSBased createStoreSignatureField(COSName var1);

    public IArgs getCmsBuilderArgs() {
        return this.cmsBuilderArgs;
    }

    public IFactory<ICMSSignatureContainerBuilder> getCmsBuilderFactory() {
        return this.cmsBuilderFactory;
    }

    @Override
    public IConversation getConversation() {
        if (this.conversation == null) {
            return super.getConversation();
        }
        return this.conversation;
    }

    public IDigester getDigester() {
        return this.digester;
    }

    protected ISigner getSigner() {
        return AdESSignerTools.getSigner((IArgs)this.getCmsBuilderArgs());
    }

    protected boolean isECSignature() {
        String algo = this.getSigner().getEncryptionAlgorithmName();
        return "ECDSA".equals(algo) || "EC".equals(algo);
    }

    protected abstract class StoreSignatureFieldCMSBased
    extends StoreSignatureFieldEncoded {
        public StoreSignatureFieldCMSBased() {
            this(CN_ADOBE_PPKLITE);
        }

        public StoreSignatureFieldCMSBased(COSName filterName) {
            super(filterName);
        }

        protected void fillField(CMSSignatureContainer result) throws IOException {
            byte[] content = LocatorTools.getBytes((ILocator)result.getLocator());
            content = this.encodeContent(content);
            COSString string = COSString.createHex((byte[])content);
            long replaceAt = this.getContentPosition();
            int length = this.getContentProxy().getLength();
            STDocument stDoc = this.getPdSignature().cosGetDoc().stGetDoc();
            IRandomAccess randomAccess = stDoc.getRandomAccess();
            ISystemSecurityHandler securityHandler = stDoc.getWriteSecurityHandler();
            COSWriter writer = new COSWriter(randomAccess, securityHandler);
            this.replace((COSObject)string, writer, replaceAt, length);
            this.getContentProxy().setObject((COSObject)string);
        }

        @Override
        public int getApproximatedContentSize() {
            return DSECMSBased.this.getSigner().getApproximatedContainerSize();
        }

        @Override
        protected IDevice getDevice() {
            return DSECMSBased.this.getSigner().getDevice();
        }

        @Override
        public void initialize(PDSignature pdSignature) {
            super.initialize(pdSignature);
            if (DSECMSBased.this.isECSignature()) {
                pdSignature.cosSetField(COSName.create((String)"R"), (COSObject)COSInteger.create((int)109));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void replace(COSObject object, COSWriter writer, long position, int length) throws IOException {
            IRandomAccess data = writer.getRandomAccess();
            data.mark();
            try {
                data.seek(position);
                if (object != null) {
                    writer.writeObject(object);
                } else {
                    writer.writeObject((COSObject)COSNull.create());
                }
                long endPosition = position + (long)length;
                if (data.getOffset() < endPosition) {
                    long dif = endPosition - data.getOffset();
                    byte[] padding = new byte[(int)dif];
                    Arrays.fill(padding, (byte)32);
                    writer.write(padding);
                } else if (data.getOffset() > endPosition) {
                    throw new IOException("Destroyed document, wrote more bytes than reserved!");
                }
            }
            finally {
                data.reset();
            }
        }

        @Override
        protected ISignatureData signByteRange(PDSignatureByteRange byteRange) throws SecurityApplicationException, IOException {
            ICMSSignatureContainerBuilder builder;
            IDigest digest = DigestTools.digest((IDigester)DSECMSBased.this.getDigester(), (InputStream)byteRange);
            IArgs args = DSECMSBased.this.getCmsBuilderArgs().copy();
            args.put("hash", (Object)digest);
            try {
                builder = (ICMSSignatureContainerBuilder)DSECMSBased.this.getCmsBuilderFactory().createInstance(args);
            }
            catch (ObjectCreationException e) {
                throw new SecurityApplicationException((Throwable)e);
            }
            IConversation conversation = builder.run();
            if (conversation.isDone()) {
                try {
                    CMSSignatureContainer cmsSignature2 = (CMSSignatureContainer)conversation.get();
                    ISignatureData result = DSECMSBased.this.createResult(cmsSignature2);
                    DSECMSBased.this.conversation = Conversation.completed((Object)result);
                    return result;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (ExecutionException e) {
                    throw (SecurityApplicationException)ExceptionTools.unwrapTyped((Throwable)e, SecurityApplicationException.class);
                }
                catch (Exception e) {
                    throw new SecurityApplicationException((Throwable)e);
                }
            }
            DSECMSBased.this.conversation = conversation.thenApply(cmsSignature -> {
                this.fillField((CMSSignatureContainer)cmsSignature);
                ISignatureData result = DSECMSBased.this.createResult((CMSSignatureContainer)cmsSignature);
                return result;
            });
            return SignatureData.create((byte[])new byte[this.getApproximatedContentSize()]);
        }
    }
}

