/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.signature;

import de.intarsys.pdf.cos.COSName;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.timestamp.ITimestampCreator;
import de.intarsys.security.app.timestamp.ITimestampRequest;
import de.intarsys.security.app.timestamp.ITimestampResponse;
import de.intarsys.security.app.timestamp.PlainTimestampRequest;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.method.pdf.signature.CommonPDDocumentSignatureEncoder;
import de.intarsys.security.method.pdf.signature.IStoreSignatureField;
import de.intarsys.security.method.pdf.signature.PDSignatureByteRange;
import de.intarsys.security.method.pdf.signature.StoreSignatureFieldEncoded;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.SignatureData;
import de.intarsys.security.timestamp.ITimestampToken;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.io.InputStream;

public class DSERFC3161
extends CommonPDDocumentSignatureEncoder {
    private IDigester digester;
    private final ITimestampCreator timestampService;

    public DSERFC3161(IDigester digester, ITimestampCreator timestampService) {
        this.digester = digester;
        this.timestampService = timestampService;
    }

    @Override
    protected IStoreSignatureField createStoreSignatureField() {
        StoreSignatureField storeField = new StoreSignatureField();
        return storeField;
    }

    public IDigester getDigester() {
        return this.digester;
    }

    public ITimestampCreator getTimestampService() {
        return this.timestampService;
    }

    private class StoreSignatureField
    extends StoreSignatureFieldEncoded {
        private static final int CONTENT_SIZE = 16384;
        private COSName CN_ETSI_RFC3161 = COSName.constant((String)"ETSI.RFC3161");

        @Override
        protected int getApproximatedContentSize() {
            return 16384;
        }

        @Override
        protected IDevice getDevice() {
            return DSERFC3161.this.getTimestampService().getDevice();
        }

        @Override
        protected String getObjectLabel() {
            return "Timestamp";
        }

        @Override
        public COSName getSubFilterName() {
            return this.CN_ETSI_RFC3161;
        }

        @Override
        protected ISignatureData signByteRange(PDSignatureByteRange byteRange) throws SecurityApplicationException, IOException {
            byte[] documentBytes = StreamTools.getBytes((InputStream)byteRange);
            IDigest digest = DSERFC3161.this.getDigester().digest(documentBytes);
            ITimestampResponse response = DSERFC3161.this.getTimestampService().createTimestamp((ITimestampRequest)new PlainTimestampRequest(digest));
            ITimestampToken timestamp = response.getTimestamp();
            return SignatureData.create((byte[])timestamp.getEncoded());
        }
    }
}

