/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.signature;

import de.intarsys.security.app.timestamp.ITimestampCreator;
import de.intarsys.security.digest.DigestTools;
import de.intarsys.security.method.common.signature.AdESSignerTools;
import de.intarsys.security.method.pdf.signature.CommonPDDocumentSignerFactory;
import de.intarsys.security.method.pdf.signature.DSERFC3161;
import de.intarsys.security.method.pdf.signature.IPDDocumentSigner;
import de.intarsys.security.method.pdf.signature.PDDocumentTimestampCreator;
import de.intarsys.tools.component.SingletonClass;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;

@SingletonClass
public class DSFactoryPAdESLTVTimestamp
extends CommonPDDocumentSignerFactory {
    private static final DSFactoryPAdESLTVTimestamp INSTANCE = new DSFactoryPAdESLTVTimestamp();

    public static DSFactoryPAdESLTVTimestamp get() {
        return INSTANCE;
    }

    protected IPDDocumentSigner basicCreateInstance(IArgs args) throws ObjectCreationException {
        ITimestampCreator timestampCreator = AdESSignerTools.createTimestampCreator((IArgs)args);
        if (timestampCreator == null) {
            throw new ObjectCreationException("Timestamp creator missing.");
        }
        IDigester digester = DigestTools.getDigester((IArgs)args, (String)"SHA-256");
        DSERFC3161 signatureEncoder = new DSERFC3161(digester, timestampCreator);
        PDDocumentTimestampCreator signer = new PDDocumentTimestampCreator(signatureEncoder);
        return signer;
    }

    public String getLabel() {
        return "PAdES-LTV Document Timestamp";
    }
}

