/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.signature;

import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.writer.COSWriter;
import de.intarsys.security.method.pdf.signature.AbstractStoreSignatureField;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.util.Arrays;

public abstract class StoreSignatureFieldEncoded
extends AbstractStoreSignatureField {
    public StoreSignatureFieldEncoded() {
        this(CN_ADOBE_PPKLITE);
    }

    public StoreSignatureFieldEncoded(COSName filterName) {
        super(filterName);
    }

    @Override
    protected byte[] encodeContent(byte[] content) throws IOException {
        int contentSize = this.getContentSize();
        byte[] data = new byte[contentSize];
        Arrays.fill(data, (byte)0);
        if (content != null) {
            if (content.length > contentSize) {
                throw new IOException(this.getObjectLabel() + " too large. Reserved byte range exceeded.");
            }
            System.arraycopy(content, 0, data, 0, content.length);
        }
        return data;
    }

    protected abstract int getApproximatedContentSize();

    @Override
    protected int getContentSize() {
        return this.getApproximatedContentSize();
    }

    protected String getObjectLabel() {
        return "Signature";
    }

    public void store(byte[] signature, IRandomAccess randomAccess) throws IOException {
        byte[] data = this.encodeContent(signature);
        randomAccess.seek(this.getContentPosition());
        COSWriter.basicWriteStringHex((IRandomAccess)randomAccess, (byte[])data);
        randomAccess.close();
        COSString replacement = COSString.createHex((byte[])data);
        this.setReplacementContent((COSObject)replacement);
    }
}

