/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.validation;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSTools;
import de.intarsys.pdf.pd.MDPPermission;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.pdf.signature.change.CommonDocumentChange;
import de.intarsys.pdf.signature.change.FieldValueChange;
import de.intarsys.pdf.signature.change.FormChangeType;
import de.intarsys.pdf.signature.change.IPDFDocumentChange;
import de.intarsys.pdf.signature.change.WidgetChange;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.method.pdf.signature.PDFSignatureContainer;
import de.intarsys.security.method.pdf.signature.PDFSignatureContainerEntry;
import de.intarsys.security.method.pdf.signature.PDSignatureByteRange;
import de.intarsys.security.method.pdf.validation.IMDPPermissionPolicy;
import de.intarsys.security.method.pdf.validation.PACKAGE;
import de.intarsys.security.standard.validation.CommonValidationMessages;
import de.intarsys.security.standard.validation.CommonValidationState;
import de.intarsys.security.standard.validation.VSDigest;
import de.intarsys.security.standard.validation.VSModification;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.validation.IValidationMessage;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class PDFSignatureContainerEntryValidator<T extends PDFSignatureContainerEntry, S extends CommonValidationState> {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    public static final Attribute ATTR_RANDOMACCESS = new Attribute("randomAccess");
    public static final Attribute STATEATTR_DEFAULTPERMISSIONS = new Attribute("defaultPermissions");
    public static final Attribute STATEATTR_PERMISSION = new Attribute("permission");
    private static final Logger Log = LoggerFactory.getLogger(PDFSignatureContainerEntryValidator.class);
    private boolean considerTransformations;
    private MDPPermission defaultPermissions = MDPPermission.Unknown;

    protected PDFSignatureContainerEntryValidator() {
    }

    protected ChangeCategory categorizeChanges(MDPPermission permissions, VSModification state, T entry) {
        List changes;
        try {
            changes = state.getChangeProvider().getSubsequentChanges();
        }
        catch (IOException e) {
            IValidationMessage msg = ValidationMessage.createError((String)Msg.getString("PDFSignatureEntryValidator.ErrorChangesUndetermined", new Object[0]));
            state.addMessage(msg);
            state.setState(2);
            return new ChangeCategory(-1, false, false);
        }
        int changeLevel = -1;
        boolean visual = false;
        boolean crucial = false;
        for (IPDFDocumentChange change : changes) {
            ChangeCategorizer categorizer = new ChangeCategorizer(change);
            ChangeCategory localCategory = categorizer.categorize(permissions);
            if (localCategory.getLevel() > changeLevel) {
                changeLevel = localCategory.getLevel();
            }
            visual = visual || localCategory.isVisual();
            crucial = crucial || localCategory.isCrucial();
        }
        return new ChangeCategory(changeLevel, visual, crucial);
    }

    protected void checkByteRange(Optional<PDSignatureByteRange> byteRange, IRandomAccess randomAccess, VSDigest state, VSModification modificationState, int signatureLength, T entry, IMDPPermissionPolicy permissionPolicy) throws IOException {
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("Checking byte range...");
        }
        if (!byteRange.isPresent()) {
            this.errorByteRangeMissing(state);
            return;
        }
        long fileSize = randomAccess.getLength();
        long byteRangeSize = byteRange.get().getTotalLength();
        COSTools.IRevision signedRevision = ((PDFSignatureContainerEntry)entry).getSignedRevision();
        if (signedRevision == null) {
            IValidationMessage msg = ValidationMessage.createError((String)Msg.getString("PDFSignatureContainerEntryValidator.ErrorRevisionNotFound", new Object[0]));
            state.invalidate(msg);
        } else {
            IValidationMessage msg;
            long revisionSize = signedRevision.getLength();
            if (byteRangeSize > revisionSize) {
                if (Log.isEnabledForLevel(Level.TRACE)) {
                    Log.trace("Byte range larger than revision size.");
                }
                msg = CommonValidationMessages.ERROR_DATA_SCOPE_BIGGER();
                state.invalidate(msg);
            } else if (byteRangeSize < revisionSize - 1L) {
                if (Log.isEnabledForLevel(Level.TRACE)) {
                    Log.trace("Byte range smaller than revision size.");
                }
                msg = CommonValidationMessages.ERROR_DATA_SCOPE_SMALLER();
                state.invalidate(msg);
            } else {
                if (Log.isEnabledForLevel(Level.TRACE)) {
                    Log.trace("Byte range matches revision size.");
                }
                msg = CommonValidationMessages.INFO_DATA_SCOPE_EXACT();
                state.increaseState(0);
                state.addMessage(msg);
            }
            if (revisionSize < fileSize) {
                if (Log.isEnabledForLevel(Level.TRACE)) {
                    Log.trace("File was extended. Checking incremental changes...");
                }
                this.checkIncrementalChanges(permissionPolicy, modificationState, entry);
            } else {
                msg = CommonValidationMessages.INFO_DATA_UNCHANGED();
                state.increaseState(0);
                state.addMessage(msg);
            }
        }
        COSArray cosByteRange = byteRange.get().cosGetObject();
        if (cosByteRange.size() != 4) {
            this.errorByteRangeAmbiguous(state);
        } else {
            int expectedGap;
            long startSigValue = cosByteRange.get(1).asInteger().longValue();
            long endSigValue = cosByteRange.get(2).asInteger().longValue();
            int actualGap = (int)(endSigValue - startSigValue);
            if (actualGap != (expectedGap = signatureLength * 2 + 2)) {
                this.errorByteRangeAmbiguous(state);
            }
        }
    }

    protected void checkIncrementalChanges(IMDPPermissionPolicy permissionPolicy, VSModification state, T entry) {
        MDPPermission permissions = permissionPolicy.getPermissions();
        if (permissions == MDPPermission.Unknown) {
            state.increaseChangeLevel(99);
            IValidationMessage msg = CommonValidationMessages.WARNING_DATA_INCREMENTALLY_CHANGED();
            state.increaseState(2);
            state.addMessage(msg);
            return;
        }
        state.increaseState(0);
        ChangeCategory changeCategory = this.categorizeChanges(permissions, state, entry);
        state.increaseChangeLevel(changeCategory.getLevel());
        switch (changeCategory.getLevel()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                state.addMessage(ValidationMessage.createInfo((String)Msg.getString("PDFSignatureContainerEntryValidator.InfoPermittedChanges", new Object[0])));
                break;
            }
            case 99: {
                state.addMessage(ValidationMessage.createWarning((String)Msg.getString("PDFSignatureContainerEntryValidator.WarningForbiddenChanges", new Object[0])));
                if (!permissionPolicy.isEnforce() && !changeCategory.isCrucial()) break;
                state.increaseState(3);
            }
        }
        if (changeCategory.isVisual()) {
            state.addMessage(ValidationMessage.createWarning((String)Msg.getString("PDFSignatureContainerEntryValidator.WarningVisualChanges", new Object[0])));
        }
    }

    protected S createTargetState(T entry) {
        return this.createTargetState(entry, -1);
    }

    protected abstract S createTargetState(T var1, int var2);

    protected void errorByteRangeAmbiguous(VSDigest state) {
        IValidationMessage msg = ValidationMessage.createError((String)Msg.getString("PDFSignatureEntryValidator.ErrorByteRangeAmbiguous", new Object[0]));
        state.invalidate(msg);
    }

    protected void errorByteRangeMissing(VSDigest state) {
        IValidationMessage msg = ValidationMessage.createError((String)Msg.getString("PDFSignatureEntryValidator.ErrorByteRangeMissing", new Object[0]));
        state.invalidate(msg);
    }

    protected int getChangeSeverity(IPDFDocumentChange change, MDPPermission permissions) {
        int localLevel;
        if ("ignorable".equals(change.getType())) {
            localLevel = 1;
            ((CommonDocumentChange)((Object)change)).setSeverity(2);
        } else if ("allowed".equals(change.getType())) {
            if (permissions == MDPPermission.NoChanges) {
                localLevel = 99;
            } else {
                localLevel = 2;
                ((CommonDocumentChange)((Object)change)).setSeverity(2);
            }
        } else if ("field".equals(change.getType())) {
            if (permissions == MDPPermission.NoChanges) {
                localLevel = 99;
            } else {
                FieldValueChange fieldValueChange = (FieldValueChange)change;
                localLevel = FormChangeType.TYPE_SIGNATURE.equals(fieldValueChange.getFieldType()) ? 3 : 4;
                ((CommonDocumentChange)((Object)change)).setSeverity(2);
            }
        } else if ("annotation".equals(change.getType()) && permissions == MDPPermission.FillSignAndAnnotate) {
            localLevel = 5;
            ((CommonDocumentChange)((Object)change)).setSeverity(2);
        } else if ("widget".equals(change.getType())) {
            WidgetChange widgetChange = (WidgetChange)change;
            HashSet<String> accepted = new HashSet<String>();
            accepted.add(FormChangeType.TYPE_TIMESTAMP);
            if (permissions != MDPPermission.NoChanges) {
                accepted.add(FormChangeType.TYPE_SIGNATURE);
            }
            if (accepted.contains(widgetChange.getAnnotationType()) && "added".equals(widgetChange.getModification())) {
                localLevel = 3;
                ((CommonDocumentChange)((Object)change)).setSeverity(2);
            } else {
                localLevel = 99;
            }
        } else {
            localLevel = 99;
        }
        return localLevel;
    }

    public MDPPermission getDefaultPermissions() {
        return this.defaultPermissions;
    }

    public boolean isConsiderTransformations() {
        return this.considerTransformations;
    }

    public void setConsiderTransformations(boolean acceptPermittedChanges) {
        this.considerTransformations = acceptPermittedChanges;
    }

    public void setDefaultPermissions(MDPPermission defaultPermissions) {
        this.defaultPermissions = defaultPermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected S validate(T entry, IDigest digest, IValidationParameters parameters) {
        PDDocument doc = ((PDFSignatureContainerEntry)entry).getDoc();
        PDFSignatureContainer container = PDFSignatureContainer.createSignatureContainer(doc);
        IRandomAccess randomAccess = (IRandomAccess)parameters.getAttribute((Object)ATTR_RANDOMACCESS);
        boolean closeRA = false;
        try {
            S entryState;
            if (randomAccess == null) {
                randomAccess = doc.getLocator().getRandomAccess();
                randomAccess.seek(0L);
                randomAccess.mark();
                closeRA = true;
            }
            S s = entryState = this.validate(entry, container, randomAccess, parameters);
            return s;
        }
        catch (IOException e) {
            S entryState = this.createTargetState(entry);
            entryState.invalidate(CommonValidationMessages.ERROR_IO((Exception)e));
            S s = entryState;
            return s;
        }
        finally {
            if (closeRA) {
                StreamTools.close((Closeable)randomAccess);
            }
        }
    }

    protected S validate(T entry, PDFSignatureContainer container, IRandomAccess randomAccess, IValidationParameters parameters) throws IOException {
        PDSignature pdSignature = ((PDFSignatureContainerEntry)entry).getPDSignature();
        COSArray cosByteRange = pdSignature.cosGetByteRange();
        Optional<PDSignatureByteRange> byteRange = Optional.ofNullable(cosByteRange).map(cbr -> new PDSignatureByteRange((COSArray)cbr, randomAccess));
        S entryState = this.verify(entry, container, randomAccess, byteRange, parameters);
        return entryState;
    }

    protected abstract S verify(T var1, PDFSignatureContainer var2, IRandomAccess var3, Optional<PDSignatureByteRange> var4, IValidationParameters var5) throws IOException;

    public static class ChangeCategory {
        private int level;
        private boolean visual;
        private boolean crucial;

        public ChangeCategory(int level, boolean visual, boolean crucial) {
            this.level = level;
            this.visual = visual;
            this.crucial = crucial;
        }

        public int getLevel() {
            return this.level;
        }

        public boolean isCrucial() {
            return this.crucial;
        }

        public boolean isVisual() {
            return this.visual;
        }
    }

    public static class ChangeCategorizer {
        private IPDFDocumentChange change;

        public ChangeCategorizer(IPDFDocumentChange change) {
            this.change = change;
        }

        public ChangeCategory categorize(MDPPermission permissions) {
            int localLevel;
            HashSet<String> nonVisualFormChanges = new HashSet<String>();
            nonVisualFormChanges.add(FormChangeType.TYPE_TIMESTAMP);
            nonVisualFormChanges.add(FormChangeType.TYPE_SIGNATURE);
            boolean visual = false;
            boolean crucial = false;
            if ("ignorable".equals(this.change.getType())) {
                localLevel = 1;
                ((CommonDocumentChange)((Object)this.change)).setSeverity(2);
            } else if ("allowed".equals(this.change.getType())) {
                if (permissions == MDPPermission.NoChanges) {
                    localLevel = 99;
                } else {
                    localLevel = 2;
                    ((CommonDocumentChange)((Object)this.change)).setSeverity(2);
                }
            } else if ("field".equals(this.change.getType())) {
                FieldValueChange fieldValueChange = (FieldValueChange)this.change;
                if (permissions == MDPPermission.NoChanges) {
                    localLevel = 99;
                } else {
                    localLevel = FormChangeType.TYPE_SIGNATURE.equals(fieldValueChange.getFieldType()) ? 3 : 4;
                    ((CommonDocumentChange)((Object)this.change)).setSeverity(2);
                }
                if (!nonVisualFormChanges.contains(fieldValueChange.getFieldType())) {
                    visual = true;
                }
            } else if ("annotation".equals(this.change.getType()) && permissions == MDPPermission.FillSignAndAnnotate) {
                localLevel = 5;
                ((CommonDocumentChange)((Object)this.change)).setSeverity(2);
                visual = true;
            } else if ("widget".equals(this.change.getType())) {
                WidgetChange widgetChange = (WidgetChange)this.change;
                HashSet<String> accepted = new HashSet<String>();
                accepted.add(FormChangeType.TYPE_TIMESTAMP);
                if (permissions != MDPPermission.NoChanges) {
                    accepted.add(FormChangeType.TYPE_SIGNATURE);
                }
                if (accepted.contains(widgetChange.getAnnotationType()) && "added".equals(widgetChange.getModification())) {
                    localLevel = 3;
                    ((CommonDocumentChange)((Object)this.change)).setSeverity(2);
                } else {
                    localLevel = 99;
                }
                if (!nonVisualFormChanges.contains(widgetChange.getAnnotationType())) {
                    visual = true;
                }
            } else if ("pagetree".equals(this.change.getType())) {
                localLevel = 99;
                crucial = true;
            } else {
                localLevel = 99;
            }
            return new ChangeCategory(localLevel, visual, crucial);
        }
    }
}

