/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.xmp;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.pd.PDObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MetadataTools {
    private static final COSName DK_Metadata = COSName.constant((String)"Metadata");
    private static final COSName CN_Metadata = COSName.constant((String)"Metadata");
    private static final COSName CN_XML = COSName.constant((String)"XML");

    public static byte[] getMetadata(COSBasedObject object) {
        COSStream metadataStream = object.cosGetField(DK_Metadata).asStream();
        return metadataStream == null ? null : metadataStream.getDecodedBytes();
    }

    public static Document getMetadataAsDocument(COSBasedObject object) throws IOException {
        byte[] metadata = MetadataTools.getMetadata(object);
        return metadata == null ? null : MetadataTools.parseXml(new ByteArrayInputStream(metadata));
    }

    private static Document parseXml(InputStream input) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(input));
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException("Failed to parse XMP metadata", e);
        }
    }

    public static void setMetadata(COSBasedObject object, byte[] data) {
        COSStream metadataStream = object.cosGetField(DK_Metadata).asStream();
        if (metadataStream == null) {
            metadataStream = COSStream.create(null);
            object.cosSetField(DK_Metadata, (COSObject)metadataStream);
        }
        metadataStream.getDict().put(PDObject.DK_Type, (COSObject)CN_Metadata);
        metadataStream.getDict().put(PDObject.DK_Subtype, (COSObject)CN_XML);
        metadataStream.setDecodedBytes(data);
    }

    public static void setMetadata(COSBasedObject object, Document document) throws IOException {
        byte[] metadata = MetadataTools.serializeXml(document);
        MetadataTools.setMetadata(object, metadata);
    }

    private static byte[] serializeXml(Document document) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(output));
            byArray = output.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (TransformerException exception) {
                throw new IOException("Failed to serialize XMP metadata", exception);
            }
        }
        output.close();
        return byArray;
    }

    private MetadataTools() {
    }
}

