/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certstore.store.db.manage;

import de.intarsys.model.common.security.Certificate;
import de.intarsys.model.common.security.KeyRef;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.certstore.store.db.manage.CertificateLibrarian;
import de.intarsys.security.certstore.store.db.model.CLCertificate;
import de.intarsys.security.certstore.store.db.model.CLCertificateRepository;
import de.intarsys.security.certstore.store.db.model.CLFolder;
import de.intarsys.security.certstore.store.db.model.CLFolderRepository;
import de.intarsys.security.certstore.store.db.model.CLItem;
import de.intarsys.security.certstore.store.db.model.CLKey;
import de.intarsys.security.certstore.store.db.model.CLKeyRepository;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;

public class SimpleCertificateLibrarian
implements CertificateLibrarian {
    private static final String ROOT_NAME = "Certificate Library Root";
    private CLCertificateRepository certificateItemRepository;
    private CLKeyRepository keyItemRepository;
    private CLFolderRepository folderRepository;

    public SimpleCertificateLibrarian(CLCertificateRepository certificateItemRepository, CLKeyRepository keyItemRepository, CLFolderRepository folderRepository) {
        this.certificateItemRepository = certificateItemRepository;
        this.keyItemRepository = keyItemRepository;
        this.folderRepository = folderRepository;
    }

    @Override
    public void addCertificate(Certificate certificate) {
        if (this.certificateItemRepository.existsByCertificate(certificate)) {
            return;
        }
        CLCertificate entry = new CLCertificate();
        entry.setName(this.computeLabel(certificate));
        entry.setCertificate(certificate);
        entry = (CLCertificate)((Object)this.certificateItemRepository.save((Object)entry));
        CLFolder folder = this.getOrCreateRoot();
        folder.addChild(entry);
    }

    @Override
    public void addKey(KeyRef keyRef) {
        Certificate certificate = keyRef.getCertificate();
        if (this.certificateItemRepository.existsByCertificate(certificate)) {
            return;
        }
        CLKey entry = new CLKey();
        entry.setName(this.computeLabel(certificate));
        entry.setKeyRef(keyRef);
        entry = (CLKey)((Object)this.keyItemRepository.save((Object)entry));
        CLFolder folder = this.getOrCreateRoot();
        folder.addChild(entry);
    }

    private String computeLabel(Certificate certificate) {
        String string;
        byte[] data = certificate.getCertificate();
        ByteArrayInputStream input = new ByteArrayInputStream(data);
        try {
            IX509Certificate x509Certificate = X509CertificateFactory.get().createCertificate((InputStream)input);
            string = CertificateTools.getSubjectLabel((IX509Certificate)x509Certificate);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | CertificateException exception) {
                return "Malformed certificate";
            }
        }
        ((InputStream)input).close();
        return string;
    }

    @Override
    public void deleteCertificate(Certificate certificate) {
        this.certificateItemRepository.findByCertificate(certificate).ifPresent(entry -> {
            CLFolder parent = entry.getParent();
            if (parent != null) {
                parent.removeChild((CLItem)((Object)entry));
            }
            this.certificateItemRepository.delete(entry);
        });
    }

    @Override
    public void deleteKey(KeyRef keyRef) {
        this.keyItemRepository.findByKeyRef(keyRef).ifPresent(entry -> {
            CLFolder parent = entry.getParent();
            if (parent != null) {
                parent.removeChild((CLItem)((Object)entry));
            }
            this.keyItemRepository.delete(entry);
        });
    }

    private CLFolder getOrCreateRoot() {
        return this.folderRepository.findRoot(ROOT_NAME).orElseGet(() -> {
            CLFolder root = new CLFolder();
            root.setName(ROOT_NAME);
            return (CLFolder)((Object)((Object)this.folderRepository.save((Object)root)));
        });
    }

    @Override
    public void updateCertificate(Certificate certificate) {
        this.addCertificate(certificate);
    }
}

