/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certstore.store.db.model;

import de.intarsys.security.certstore.store.db.model.CLItem;
import jakarta.persistence.CascadeType;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import java.util.ArrayList;
import java.util.List;

@Entity
@DiscriminatorValue(value="folder")
public class CLFolder
extends CLItem {
    @OneToMany(mappedBy="parent", cascade={CascadeType.MERGE})
    @OrderBy(value="index ASC")
    private List<CLItem> children;

    public void addChild(CLItem item) {
        this.addChild(item, -1);
    }

    public void addChild(CLItem item, int index) {
        item.setParent(this);
        if (index < 0) {
            int newIndex = this.getChildren().size();
            this.getChildren().add(item);
            item.setIndex(newIndex);
        } else {
            this.getChildren().add(index, item);
            this.adjustChildIndices();
        }
    }

    protected void adjustChildIndices() {
        int i = 0;
        for (CLItem child : this.getChildren()) {
            if (child.getIndex() != i) {
                child.setIndex(i);
            }
            ++i;
        }
    }

    public List<CLItem> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<CLItem>();
        }
        return this.children;
    }

    public void removeChild(CLItem item) {
        this.getChildren().remove((Object)item);
        item.setParent(null);
        item.setIndex(-1);
        this.adjustChildIndices();
    }

    public void setChildren(List<CLItem> children) {
        this.children = children;
    }

    public int size() {
        return this.getChildren().size();
    }
}

