/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certstore.store.db.model;

import de.intarsys.jpa.common.JPAModelTools;
import de.intarsys.jpa.common.TrackedPersistentObject;
import de.intarsys.security.certstore.store.db.model.CLFolder;
import de.intarsys.tools.attribute.AttributeMap;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Query;
import jakarta.persistence.Table;
import java.util.HashMap;
import java.util.List;

@Entity
@Table(name="t_clitem")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="c_type", discriminatorType=DiscriminatorType.STRING)
public abstract class CLItem
extends TrackedPersistentObject {
    @Column(name="c_index", nullable=false)
    private int index;
    @JoinColumn(name="fk_parent")
    @ManyToOne
    private CLFolder parent;
    @Column(name="c_name", nullable=false)
    private String name;
    private transient AttributeMap attributes = new AttributeMap();

    public static int countChildren(EntityManager em, CLFolder folder) {
        HashMap<String, CLFolder> parameters = new HashMap<String, CLFolder>();
        parameters.put("parent", folder);
        return CLItem.count((EntityManager)em, CLItem.class, parameters);
    }

    public static List<CLItem> selectChildren(EntityManager em, CLFolder folder) {
        HashMap<String, CLFolder> parameters = new HashMap<String, CLFolder>();
        parameters.put("parent", folder);
        Object queryString = CLItem.createDefaultQuery(CLItem.class, parameters);
        queryString = (String)queryString + " ORDER BY x.index ASC";
        return CLItem.query((EntityManager)em, CLItem.class, (String)queryString, parameters);
    }

    public static List<CLItem> selectChildren(EntityManager em, CLFolder folder, int startIndex) {
        StringBuilder queryString = new StringBuilder();
        queryString.append("SELECT x FROM ");
        queryString.append(JPAModelTools.getEntityAlias(CLItem.class));
        queryString.append(" x WHERE x.parent = :parent AND x.index >= :startIndex ORDER BY x.index ASC");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("parent", (Object)folder);
        parameters.put("startIndex", startIndex);
        Query query = em.createQuery(queryString.toString());
        return CLItem.query(CLItem.class, (Query)query, parameters);
    }

    protected CLItem() {
    }

    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public CLFolder getParent() {
        return this.parent;
    }

    public String getPath() {
        String path = "/" + this.getName();
        if (this.getParent() != null) {
            path = this.getParent().getPath() + path;
        }
        return path;
    }

    public Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setName(String name) {
        if (!this.willChange("name", this.name, name)) {
            return;
        }
        this.name = name;
    }

    public void setParent(CLFolder folder) {
        this.parent = folder;
    }
}

