/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certstore.store.db.node;

import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certstore.library.core.ICertStoreNodeProvider;
import de.intarsys.security.certstore.store.db.model.CLCertificate;
import de.intarsys.security.certstore.store.db.node.CLLeafNode;
import de.intarsys.security.virtualkeystore.core.VirtualKeyStore;
import de.intarsys.security.virtualkeystore.db.DBKeyStore;
import de.intarsys.security.virtualkeystore.db.DBKeyStoreCertificateEntry;

public class CLCertificateNode
extends CLLeafNode<CLCertificate, DBKeyStoreCertificateEntry> {
    protected CLCertificateNode(ICertStoreNodeProvider nodeProvider, CLCertificate entry) {
        super(nodeProvider, entry);
    }

    public String getIconName() {
        IX509Certificate cert = this.testCertificate();
        if (cert == null) {
            return "icons/error";
        }
        if (cert instanceof IX509AttributeCertificate) {
            if (this.getKeyStoreEntry().isTrusted()) {
                return "icons/attrcert_trusted";
            }
            return "icons/attrcert";
        }
        if (this.getKeyStoreEntry().isTrusted()) {
            return "icons/certificate_trusted";
        }
        return "icons/certificate";
    }

    @Override
    protected DBKeyStoreCertificateEntry getKeyStoreEntry() {
        return new DBKeyStoreCertificateEntry((DBKeyStore)VirtualKeyStore.get(), ((CLCertificate)((Object)this.getEntry())).getCertificate());
    }

    public int getType() {
        try {
            IX509Certificate certificate = this.getCertificate();
            if (certificate instanceof IX509AttributeCertificate) {
                return 8;
            }
            if (certificate instanceof IX509PublicKeyCertificate) {
                return 4;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }
}

