/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certstore.store.db.node;

import de.intarsys.security.certstore.library.core.ICertStoreNodeProvider;
import de.intarsys.security.certstore.node.CommonCertStoreContainerNode;
import de.intarsys.security.certstore.node.ICertStoreCertificateNode;
import de.intarsys.security.certstore.node.ICertStoreContainerNode;
import de.intarsys.security.certstore.node.ICertStoreNode;
import de.intarsys.security.certstore.node.ICertStoreNodeFactory;
import de.intarsys.security.certstore.node.IMutableCertStoreContainerNode;
import de.intarsys.security.certstore.store.db.model.CLCertificate;
import de.intarsys.security.certstore.store.db.model.CLFolder;
import de.intarsys.security.certstore.store.db.model.CLItem;
import de.intarsys.security.certstore.store.db.model.CLKey;
import de.intarsys.security.certstore.store.db.node.CLLeafNode;
import de.intarsys.security.certstore.store.db.node.CLNodeProvider;
import de.intarsys.security.certstore.store.db.node.ICLItemNode;
import de.intarsys.security.virtualkeystore.core.IVirtualKeyStoreEntry;
import de.intarsys.security.virtualkeystore.core.IVirtualKeyStoreIDEntry;
import de.intarsys.security.virtualkeystore.db.DBKeyStoreCertificateEntry;
import de.intarsys.security.virtualkeystore.db.DBKeyStoreIDEntry;
import de.intarsys.tools.collection.ConversionIterator;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.monitor.IMonitor;
import de.intarsys.tools.monitor.MonitorTools;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLFolderNode
extends CommonCertStoreContainerNode
implements IMutableCertStoreContainerNode,
ICertStoreNodeFactory,
ICLItemNode {
    private static final Logger Log = LoggerFactory.getLogger(CLFolderNode.class);
    private CLFolder folder;
    private IMonitor monitor;

    public CLFolderNode(ICertStoreNodeProvider nodeProvider, CLFolder folder) {
        super(nodeProvider);
        this.folder = folder;
        this.createMonitor();
    }

    public void addChild(ICertStoreNode node) {
        this.addChild(node, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(ICertStoreNode node, int index) {
        Log.trace("Adding certificate node '" + node.getName() + "'");
        this.monitor.attach();
        try {
            CLItem entry = ((ICLItemNode)node).getItem();
            this.getFolder().addChild(entry, index);
        }
        finally {
            this.monitor.detach();
        }
    }

    protected void basicDispose() {
        super.dispose();
        this.getNodeProvider().getEntityManager().remove((Object)this.getFolder());
    }

    protected List<CLItem> basicGetChildItems() {
        return CLItem.selectChildren(this.getNodeProvider().getEntityManager(), this.getFolder());
    }

    protected List<ICertStoreNode> basicGetChildren() {
        List<CLItem> entries = this.basicGetChildItems();
        return ListTools.toList((Iterator)new ConversionIterator<CLItem, ICertStoreNode>(entries.iterator()){

            protected ICertStoreNode createTargetObject(CLItem sourceObject) {
                ICertStoreNode node = CLLeafNode.create((ICertStoreNodeProvider)CLFolderNode.this.getNodeProvider(), sourceObject);
                node.setParent((ICertStoreContainerNode)CLFolderNode.this);
                return node;
            }
        });
    }

    public ICertStoreCertificateNode createCertificateNode(IVirtualKeyStoreEntry entry) {
        if (entry instanceof IVirtualKeyStoreIDEntry) {
            DBKeyStoreIDEntry keyStoreEntry = (DBKeyStoreIDEntry)entry;
            CLKey keyEntry = new CLKey();
            keyEntry.setKeyRef(keyStoreEntry.getDbKeyRef());
            this.getNodeProvider().getEntityManager().persist((Object)keyEntry);
            return (ICertStoreCertificateNode)CLLeafNode.create((ICertStoreNodeProvider)this.getNodeProvider(), keyEntry);
        }
        if (entry instanceof DBKeyStoreCertificateEntry) {
            DBKeyStoreCertificateEntry keyStoreEntry = (DBKeyStoreCertificateEntry)entry;
            CLCertificate certificateEntry = new CLCertificate();
            certificateEntry.setCertificate(keyStoreEntry.getDBCertificate());
            this.getNodeProvider().getEntityManager().persist((Object)certificateEntry);
            return (ICertStoreCertificateNode)CLLeafNode.create((ICertStoreNodeProvider)this.getNodeProvider(), certificateEntry);
        }
        throw new IllegalArgumentException("entry type not supported");
    }

    public IMutableCertStoreContainerNode createContainerNode() {
        CLFolder folder = new CLFolder();
        this.getNodeProvider().getEntityManager().persist((Object)folder);
        return (IMutableCertStoreContainerNode)CLLeafNode.create((ICertStoreNodeProvider)this.getNodeProvider(), folder);
    }

    protected void createMonitor() {
        this.monitor = MonitorTools.getMonitor((String)CLFolderNode.class.getName());
    }

    public void dispose() {
        this.basicDispose();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CLFolderNode)) {
            return false;
        }
        CLFolderNode node = (CLFolderNode)obj;
        return this.getFolder() == node.getFolder() || this.getFolder().getId() == node.getFolder().getId();
    }

    public CLFolder getFolder() {
        return this.folder;
    }

    public int getIndex(ICertStoreNode node) {
        return ((ICLItemNode)node).getItem().getIndex();
    }

    @Override
    public CLFolder getItem() {
        return this.getFolder();
    }

    public String getName() {
        return this.getFolder().getName();
    }

    public CLNodeProvider getNodeProvider() {
        return (CLNodeProvider)super.getNodeProvider();
    }

    public ICertStoreContainerNode getParent() {
        ICertStoreContainerNode parent = super.getParent();
        if (parent == null) {
            parent = (ICertStoreContainerNode)CLLeafNode.create((ICertStoreNodeProvider)this.getNodeProvider(), this.getFolder().getParent());
        }
        return parent;
    }

    public int hashCode() {
        return this.getFolder().getId();
    }

    public void removeChild(ICertStoreNode node) {
        CLItem entry = ((ICLItemNode)node).getItem();
        List<CLItem> nextItems = CLItem.selectChildren(this.getNodeProvider().getEntityManager(), this.getFolder(), entry.getIndex() + 1);
        for (CLItem nextItem : nextItems) {
            nextItem.setIndex(nextItem.getIndex() - 1);
        }
        entry.setParent(null);
        entry.setIndex(-1);
    }

    public void setFolder(CLFolder folder) {
        this.folder = folder;
    }

    public void setName(String name) {
        this.getFolder().setName(name);
    }

    public int size() {
        return CLItem.countChildren(this.getNodeProvider().getEntityManager(), this.getFolder());
    }

    public void sort(Comparator<ICertStoreNode> comparator) {
        List<ICertStoreNode> children = this.basicGetChildren();
        Collections.sort(children, comparator);
        int index = 0;
        for (ICertStoreNode child : children) {
            CLItem item = ((ICLItemNode)child).getItem();
            item.setIndex(index++);
        }
    }
}

