/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certstore.store.db.node;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certstore.library.core.ICertStoreNodeProvider;
import de.intarsys.security.certstore.store.db.model.CLKey;
import de.intarsys.security.certstore.store.db.node.CLLeafNode;
import de.intarsys.security.virtualkeystore.core.VirtualKeyStore;
import de.intarsys.security.virtualkeystore.db.DBKeyStore;
import de.intarsys.security.virtualkeystore.db.DBKeyStoreIDEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLKeyNode
extends CLLeafNode<CLKey, DBKeyStoreIDEntry> {
    private static final Logger Log = LoggerFactory.getLogger(CLKeyNode.class);

    public CLKeyNode(ICertStoreNodeProvider nodeProvider, CLKey entry) {
        super(nodeProvider, entry);
    }

    public String getIconName() {
        IX509Certificate cert = this.testCertificate();
        if (cert == null) {
            return "icons/error";
        }
        if (this.getKeyStoreEntry().isTrusted()) {
            return "icons/key_trusted";
        }
        return "icons/key";
    }

    @Override
    protected DBKeyStoreIDEntry getKeyStoreEntry() {
        return new DBKeyStoreIDEntry((DBKeyStore)VirtualKeyStore.get(), ((CLKey)((Object)this.getEntry())).getKeyRef());
    }

    public int getType() {
        return 2;
    }
}

