/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certstore.store.db.node;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certstore.library.core.ICertStoreNodeProvider;
import de.intarsys.security.certstore.node.CertStoreNodeBase;
import de.intarsys.security.certstore.node.ICertStoreCertificateNode;
import de.intarsys.security.certstore.node.ICertStoreContainerNode;
import de.intarsys.security.certstore.node.ICertStoreNode;
import de.intarsys.security.certstore.store.db.model.CLCertificate;
import de.intarsys.security.certstore.store.db.model.CLFolder;
import de.intarsys.security.certstore.store.db.model.CLItem;
import de.intarsys.security.certstore.store.db.model.CLKey;
import de.intarsys.security.certstore.store.db.node.CLCertificateNode;
import de.intarsys.security.certstore.store.db.node.CLFolderNode;
import de.intarsys.security.certstore.store.db.node.CLKeyNode;
import de.intarsys.security.certstore.store.db.node.CLNodeProvider;
import de.intarsys.security.certstore.store.db.node.ICLItemNode;
import de.intarsys.security.virtualkeystore.db.DBKeyStoreEntry;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.adapter.IAdapterSupport;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.X509Extension;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CLLeafNode<T extends CLItem, V extends DBKeyStoreEntry>
extends CertStoreNodeBase
implements ICertStoreCertificateNode,
ICLItemNode,
IAdapterSupport {
    private static final Logger Log = LoggerFactory.getLogger(CLLeafNode.class);
    private T entry;

    public static ICertStoreNode create(ICertStoreNodeProvider nodeProvider, CLItem entry) {
        if (entry instanceof CLFolder) {
            return new CLFolderNode(nodeProvider, (CLFolder)entry);
        }
        if (entry instanceof CLCertificate) {
            return new CLCertificateNode(nodeProvider, (CLCertificate)entry);
        }
        if (entry instanceof CLKey) {
            return new CLKeyNode(nodeProvider, (CLKey)entry);
        }
        return null;
    }

    protected CLLeafNode(ICertStoreNodeProvider nodeProvider, T entry) {
        super(nodeProvider);
        this.entry = entry;
    }

    public void dispose() {
        super.dispose();
        this.getNodeProvider().getEntityManager().remove(this.getEntry());
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        CLLeafNode node = (CLLeafNode)obj;
        if (this.getEntry() == null) {
            return node.getEntry() == null;
        }
        return this.getEntry() == node.getEntry() || this.getEntry().getId() == node.getEntry().getId();
    }

    public <A> A getAdapter(Class<A> clazz) {
        return (A)AdapterTools.getAdapter(this.getKeyStoreEntry(), clazz, null);
    }

    public IX509Certificate getCertificate() {
        try {
            return this.getKeyStoreEntry().getCertificate();
        }
        catch (IOException | GeneralSecurityException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public T getEntry() {
        return this.entry;
    }

    protected ExtendedKeyUsage getExtendedKeyUsage(IX509PublicKeyCertificate certificate) {
        try {
            ASN1Primitive derKeyUsage = CertificateTools.getExtensionValue((X509Extension)certificate, (String)"2.5.29.37");
            if (derKeyUsage != null) {
                return ExtendedKeyUsage.getInstance((Object)derKeyUsage);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public String getId() {
        return super.getId() + " [" + this.getEntry().getId() + "]";
    }

    public T getItem() {
        return this.getEntry();
    }

    protected abstract V getKeyStoreEntry();

    public String getName() {
        return ((CLItem)((Object)this.getEntry())).getName();
    }

    public CLNodeProvider getNodeProvider() {
        return (CLNodeProvider)super.getNodeProvider();
    }

    public ICertStoreContainerNode getParent() {
        ICertStoreContainerNode parent = super.getParent();
        if (parent == null) {
            parent = (ICertStoreContainerNode)CLLeafNode.create((ICertStoreNodeProvider)this.getNodeProvider(), ((CLItem)((Object)this.getEntry())).getParent());
        }
        return parent;
    }

    public int hashCode() {
        return this.getEntry().getId();
    }

    public void setName(String name) {
        ((CLItem)((Object)this.getEntry())).setName(name);
    }

    protected IX509Certificate testCertificate() {
        if (this.getCertificate() == null) {
            return null;
        }
        return this.getCertificate();
    }
}

