/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certstore.store.db.node;

import de.intarsys.security.certstore.library.core.CommonCertStoreNodeProvider;
import de.intarsys.security.certstore.library.core.ICertStoreNodeProvider;
import de.intarsys.security.certstore.node.ICertStoreContainerNode;
import de.intarsys.security.certstore.store.db.model.CLFolder;
import de.intarsys.security.certstore.store.db.model.CLItem;
import de.intarsys.security.certstore.store.db.model.CLItemRepository;
import de.intarsys.security.certstore.store.db.node.CLFolderNode;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.beans.factory.annotation.Autowired;

public class CLNodeProvider
extends CommonCertStoreNodeProvider {
    private static final String ROOT_FOLDER_NAME = "Certificate Library Root";
    private static final Logger Log = LoggerFactory.getLogger(CLNodeProvider.class);
    private ICertStoreContainerNode container;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private CLItemRepository itemRepository;

    protected ICertStoreContainerNode createContainerNode() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("parent", null);
        parameters.put("name", ROOT_FOLDER_NAME);
        CLFolder rootItem = (CLFolder)((Object)CLItem.querySingle((EntityManager)this.getEntityManager(), CLFolder.class, parameters));
        if (rootItem == null) {
            rootItem = new CLFolder();
            rootItem.setName(ROOT_FOLDER_NAME);
            this.getItemRepository().save((Object)rootItem);
        }
        return new CLFolderNode((ICertStoreNodeProvider)this, rootItem);
    }

    public ICertStoreContainerNode getCertStoreNode() {
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("{}: enter {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)"getCertStoreNode");
        }
        if (this.container == null) {
            this.container = this.createContainerNode();
        }
        return this.container;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public CLItemRepository getItemRepository() {
        return this.itemRepository;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void setItemRepository(CLItemRepository itemRepository) {
        this.itemRepository = itemRepository;
    }
}

