/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certstore.store.db.tools;

import de.intarsys.model.common.file.DBFileSystem;
import de.intarsys.security.certstore.processor.CertificateStoreProcessorTools;
import de.intarsys.security.certstore.store.db.model.CertificateUpdate;
import de.intarsys.security.certstore.store.db.tools.PACKAGE;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.locator.ClassLoaderResourceLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.progress.IProgressMonitor;
import de.intarsys.tools.reporter.Reporter;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.transaction.ThreadExclusiveTransactionManager;
import jakarta.persistence.EntityManager;
import java.io.IOException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBCertStoreInitializerImportKeystores
implements IFunctor<Void> {
    private static final Logger Log = LoggerFactory.getLogger(DBCertStoreInitializerImportKeystores.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private boolean stopRequested = false;
    private final Object initLock = new Object();

    protected String createGroupName(ILocator locator, String parentPath) {
        String name = LocatorTools.getBaseName((ILocator)locator);
        int end = name.indexOf(".update");
        if (end > -1) {
            name = name.substring(0, end);
        }
        if (StringTools.isEmpty((String)parentPath)) {
            return name;
        }
        return parentPath + "/" + name;
    }

    protected EntityManager getEntityManager() {
        return null;
    }

    private ILocator[] getKeyStoreFilesAndDirectories(ILocator keystoresDir) throws IOException {
        if (!keystoresDir.isDirectory()) {
            return new ILocator[0];
        }
        return keystoresDir.listLocators((parent, name) -> parent.getChild(name).isDirectory() && !name.equalsIgnoreCase("CVS") || name.endsWith(".keystore"));
    }

    protected void initDefaultKeystore(EntityManager em, ILocator file, String parentPath, String parentPathLabel) {
        String updateName = parentPath + LocatorTools.getBaseName((ILocator)file);
        CertificateUpdate update = CertificateUpdate.selectByName(em, updateName);
        if (update != null && update.isStateInstalled()) {
            return;
        }
        String name = this.createGroupName(file, parentPathLabel);
        try {
            CertificateStoreProcessorTools.importAll((ILocator)file, (String)name);
        }
        catch (Exception e) {
            throw ExceptionTools.wrap((Throwable)e);
        }
        CertificateUpdate newUpdate = update;
        if (update == null) {
            newUpdate = new CertificateUpdate();
            newUpdate.setName(updateName);
        }
        newUpdate.setState(CertificateUpdate.STATE_INSTALLED);
        em.persist((Object)newUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDefaultKeystores(EntityManager em, ILocator locator, String parentPath, String parentPathLabel) {
        if (this.isKeystore(locator)) {
            this.initDefaultKeystore(em, locator, (String)parentPath, (String)parentPathLabel);
        } else {
            if (StringTools.isEmpty((String)parentPathLabel)) {
                parentPath = "";
                parentPathLabel = "/";
            } else {
                parentPath = (String)parentPath + locator.getName() + "/";
                String label = Msg.getString("CertificateStoreInitializer.LabelSubdirectory_" + locator.getName(), new Object[0]);
                parentPathLabel = (String)parentPathLabel + label + "/";
            }
            try {
                ILocator[] children = locator.listLocators(null);
                for (int i = 0; i < children.length && !this.stopRequested; ++i) {
                    ILocator child = children[i];
                    Object object = this.initLock;
                    synchronized (object) {
                        this.initDefaultKeystores(em, child, (String)parentPath, (String)parentPathLabel);
                        continue;
                    }
                }
            }
            catch (Exception e) {
                throw ExceptionTools.wrap((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDefaultKeystores(IArgs args) throws FunctorException {
        IProgressMonitor monitor = Reporter.get().reportActivityStart(Msg.getMessage("CertificateStoreInitializer.ActivityInitializing", new Object[0]), 0);
        try {
            ClassLoaderResourceLocator keystoresDir = new ClassLoaderResourceLocator(this.getClass().getClassLoader(), "keystores");
            this.initDefaultKeystores(this.getEntityManager(), (ILocator)keystoresDir, null, null);
        }
        finally {
            monitor.end();
        }
    }

    protected void initFileSystem() {
        DBFileSystem.get().initialize(this.getEntityManager());
    }

    protected boolean isKeystore(ILocator locator) {
        return "keystore".equalsIgnoreCase(LocatorTools.getExtension((ILocator)locator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Void perform(IFunctorCall call) throws FunctorException {
        IArgs args = call.getArgs();
        ThreadExclusiveTransactionManager tm = ThreadExclusiveTransactionManager.install();
        try {
            this.initFileSystem();
            this.initDefaultKeystores(args);
        }
        finally {
            tm.restore();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopRequested(Set visited) {
        this.stopRequested = true;
        Object object = this.initLock;
        synchronized (object) {
            return true;
        }
    }
}

