/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.collectdepiction;

import de.intarsys.cloudsuite.gears.action.ActionInvocation;
import de.intarsys.cloudsuite.gears.action.ServerAction;
import de.intarsys.cloudsuite.meeting.bridglet.BridgletHandler;
import de.intarsys.cloudsuite.meeting.core.IMeeting;
import de.intarsys.cloudsuite.meeting.core.IMeetingFactory;
import de.intarsys.cloudsuite.meeting.core.IMeetingHandler;
import de.intarsys.cloudsuite.meeting.core.IParticipant;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.conversation.impl.HttpRedirectStage;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.ArgsBuilder;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.jaxrs.RequestContext;
import de.intarsys.tools.loadbalance.LoadBalanceContext;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.url.URLEncodingTools;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.annotation.Autowired;

public class CollectDepiction
extends ServerAction {
    private static final String PARAM_DESCRIPTION = "description";
    private static final String PARAM_LABEL = "label";
    private static final String PARAM_STATE = "state";
    private static final String PATH_COLLECT_DEPICTION = "collect/depiction";
    public static final String ARG_REDIRECT_URI = "redirectUri";
    private static final String ARG_DEBUG_BRIDGE_URL_CLIENT = "debug.bridge.urlClient";
    private static final String PARAM_URL_SERVER = "urlServer";
    @Autowired
    private IMeetingFactory meetingFactory;
    private URI urlUi = URI.create("bridge");

    protected IConversation<?> basicInvoke(ActionInvocation invocation) throws Exception {
        IConversation conversation = this.createConversation();
        IMeeting meeting = this.createMeeting(conversation);
        String redirectUri = ArgTools.getString((IArgs)invocation.getArgs(), (String)ARG_REDIRECT_URI, null);
        UriBuilder uriBuilder = this.createUriBuilder(meeting, redirectUri);
        IReplyStage replyStage = this.createReplyStage(conversation, uriBuilder);
        conversation.setReplyStage(replyStage);
        this.getConversationRegistry().publish(conversation);
        return conversation;
    }

    protected IConversation createConversation() {
        Conversation conversation = new Conversation("CollectSignature");
        return conversation;
    }

    protected IMeeting createMeeting(final IConversation conversation) {
        IArgs argsHandler = new ArgsBuilder().put("bridge", (Object)ArgTools.getArgs((IArgs)this.getArgs(), (String)"bridge", (IArgs)Args.create())).put("bridglet", (Object)ArgTools.getArgs((IArgs)this.getArgs(), (String)"bridglet", (IArgs)Args.create())).putIfAbsent("bridglet.factory", (Object)"de.intarsys.cloudsuite.bridge.control.workflow.PenTabletBridglet").build();
        BridgletHandler meetingHandler = new BridgletHandler(argsHandler){

            protected Object basicCall(IMeeting meeting, IParticipant participant, String name, IArgs args) throws Exception {
                if ("foo".equals(name)) {
                    return CollectDepiction.this.doFoo(conversation, args);
                }
                return super.basicCall(meeting, participant, name, args);
            }

            protected void hookOutcomeCancel(IMeeting meeting) throws Exception {
                CollectDepiction.this.doCancel(conversation);
            }

            protected void hookOutcomeFail(IMeeting meeting) throws Exception {
                CollectDepiction.this.doFail(conversation, this.getOutcomeException());
            }

            protected void hookOutcomeOk(IMeeting meeting) throws Exception {
                CollectDepiction.this.doOk(conversation, this.getResult());
            }
        };
        IArgs argsMeeting = ArgTools.getArgs((IArgs)this.getArgs(), (String)"meeting", (IArgs)Args.create());
        return this.getMeetingFactory().createMeeting((IMeetingHandler)meetingHandler, argsMeeting);
    }

    protected IReplyStage createReplyStage(IConversation conversation, UriBuilder uriBuilder) {
        HttpRedirectStage replyStage = new HttpRedirectStage(uriBuilder.toString(), false, true);
        replyStage.onAck(ignore -> {
            IllegalStateException reentry = new IllegalStateException("Bridge not correctly started");
            this.doFail(conversation, reentry);
        });
        return replyStage;
    }

    protected UriBuilder createUriBuilder(IMeeting meeting, String redirectUri) {
        UriBuilder result;
        String debugUrlClient = ArgTools.getString((IArgs)this.getArgs(), (String)ARG_DEBUG_BRIDGE_URL_CLIENT, null);
        if (StringTools.isEmpty((String)debugUrlClient)) {
            URI uriUi = this.getUrlUi();
            if (uriUi.isAbsolute()) {
                result = UriBuilder.fromUri((URI)uriUi);
                LoadBalanceContext.get().processUri(result);
                UriBuilder uriBuilderServer = RequestContext.get().getUriBuilderContext();
                result.queryParam(PARAM_URL_SERVER, new Object[]{uriBuilderServer.build(new Object[0]).toString()});
            } else {
                result = RequestContext.get().getUriBuilderContext();
                result.path(uriUi.toString());
            }
        } else {
            result = UriBuilder.fromUri((String)debugUrlClient);
            LoadBalanceContext.get().processUri(result);
            UriBuilder uriBuilderServer = RequestContext.get().getUriBuilderContext();
            result.queryParam(PARAM_URL_SERVER, new Object[]{uriBuilderServer.build(new Object[0]).toString()});
        }
        result.path(PATH_COLLECT_DEPICTION);
        result.queryParam(PARAM_STATE, new Object[]{meeting.getId()});
        String label = "Collect handwriting";
        result.queryParam(PARAM_LABEL, new Object[]{ArgTools.getString((IArgs)this.getArgs(), (String)"bridglet.label", (String)label)});
        String description = "Collect handwriting";
        result.queryParam(PARAM_DESCRIPTION, new Object[]{ArgTools.getString((IArgs)this.getArgs(), (String)"bridglet.description", (String)description)});
        if (!StringTools.isEmpty((String)redirectUri)) {
            result.queryParam(ARG_REDIRECT_URI, new Object[]{URLEncodingTools.encodeCharset((String)redirectUri, (Charset)StandardCharsets.UTF_8)});
        }
        return result;
    }

    protected void doCancel(IConversation conversation) {
        conversation.cancel(false);
    }

    protected void doFail(IConversation conversation, Exception outcomeException) {
        conversation.completeExceptionally((Throwable)outcomeException);
    }

    protected Object doFoo(IConversation conversation, IArgs args) {
        return null;
    }

    protected void doOk(IConversation conversation, IArgs result) {
        IArgs depictionArgs = new ArgsBuilder().put("type", (Object)"samples").put("format", (Object)"penTabletSignature").put("samples", result.get("timeSeriesBdb")).build();
        conversation.complete((Object)depictionArgs);
    }

    public IMeetingFactory getMeetingFactory() {
        return this.meetingFactory;
    }

    public URI getUrlUi() {
        return this.urlUi;
    }

    public void setMeetingFactory(IMeetingFactory meetingFactory) {
        this.meetingFactory = meetingFactory;
    }

    public void setUrlUi(URI urlUi) {
        this.urlUi = urlUi;
    }
}

