/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.client;

import de.intarsys.cloudsuite.gears.core.client.CommonStub;
import de.intarsys.cloudsuite.gears.core.client.GearsServiceException;
import de.intarsys.cloudsuite.gears.core.client.PageStub;
import de.intarsys.cloudsuite.gears.core.client.Protocol;
import de.intarsys.conversation.service.client.api.ConversationalResponse;
import de.intarsys.conversation.service.client.api.DtoConversationSnapshot;
import de.intarsys.conversation.service.client.api.DtoHttpRedirectStage;
import de.intarsys.conversation.service.client.api.DtoReplyStage;
import de.intarsys.conversation.service.client.api.DtoResultStage;
import de.intarsys.conversation.service.client.api.RequestAcknowledge;
import de.intarsys.conversation.service.client.api.RequestCancel;
import de.intarsys.conversation.service.client.api.ResponseAcknowledge;
import de.intarsys.conversation.service.client.api.ResponseCancel;
import de.intarsys.conversation.service.component.api.Outcome;
import de.intarsys.conversation.service.component.api.RequestResume;
import de.intarsys.conversation.service.component.api.ResponseResume;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Constructor;
import java.util.Map;

public abstract class ConversationStub
extends PageStub {
    private static final String OP_CANCEL = "cancel";
    private static final String OP_ACKNOWLEDGE = "acknowledge";
    private static final String PATH_ACKNOWLEDGE = "/api/v1/flow/conversation/acknowledge";
    private static final String PATH_CANCEL = "/api/v1/flow/conversation/cancel";
    private static final String PATH_RESUME = "/api/v1/flow/conversation/resume";
    private final String handle;
    private DtoReplyStage replyStage;
    private Map<String, String> links;

    protected static String createUrl(ConversationalResponse response) {
        DtoReplyStage stage = response.getSnapshot().getReplyStage();
        if (stage instanceof DtoHttpRedirectStage) {
            return ((DtoHttpRedirectStage)stage).getUrl();
        }
        return null;
    }

    protected ConversationStub(Protocol protocol, ConversationalResponse response) throws GearsServiceException {
        this(protocol, ConversationStub.createUrl(response), response.getSnapshot().getConversationHandle());
        this.handleSnapshot(response.getSnapshot());
    }

    protected ConversationStub(Protocol protocol, String rootUrl, String handle) {
        super(protocol, rootUrl);
        this.handle = handle;
    }

    public ResponseAcknowledge acknowledge() throws GearsServiceException {
        return this.acknowledge(null);
    }

    public ResponseAcknowledge acknowledge(Object value) throws GearsServiceException {
        RequestAcknowledge reqAcknowledge = new RequestAcknowledge(this.getHandle());
        reqAcknowledge.setValue(value);
        ResponseAcknowledge ack = this.getProtocol().postJson(this.getLink(OP_ACKNOWLEDGE, PATH_ACKNOWLEDGE), null, this.createParameters(), reqAcknowledge, ResponseAcknowledge.class);
        this.handleSnapshot(ack.getSnapshot());
        return ack;
    }

    public ResponseCancel cancel() throws GearsServiceException {
        RequestCancel reqCancel = new RequestCancel(this.getHandle());
        return this.getProtocol().postJson(this.getLink(OP_CANCEL, PATH_CANCEL), null, this.createParameters(), reqCancel, ResponseCancel.class);
    }

    public <S extends CommonStub> S followRedirect(Class<S> target) throws GearsServiceException {
        try {
            DtoHttpRedirectStage stage = (DtoHttpRedirectStage)this.getReplyStage();
            Constructor<S> constructor = target.getConstructor(Protocol.class, String.class);
            CommonStub newStub = (CommonStub)constructor.newInstance(this.getProtocol(), stage.getUrl());
            return (S)newStub;
        }
        catch (Exception e) {
            throw new GearsServiceException(e);
        }
    }

    public String getHandle() {
        return this.handle;
    }

    protected String getLink(String operation, String defaultValue) {
        if (this.links == null) {
            return defaultValue;
        }
        String link = this.links.get(operation);
        if (link != null) {
            return link;
        }
        return defaultValue;
    }

    public DtoReplyStage getReplyStage() {
        return this.replyStage;
    }

    protected DtoHttpRedirectStage getReplyStageHttpRedirect() {
        return (DtoHttpRedirectStage)this.replyStage;
    }

    protected DtoResultStage getReplyStageResult() {
        return (DtoResultStage)this.replyStage;
    }

    protected void handleSnapshot(DtoConversationSnapshot snapshot) {
        this.setReplyStage(snapshot.getReplyStage());
        this.setLinks(snapshot.getLinks());
    }

    public Response resumeGet(Outcome outcome) throws GearsServiceException {
        Map<String, String> params = this.createParameters();
        params.put("state", this.getHandle());
        if (outcome != null) {
            params.put("outcome", outcome.toString());
            this.setReplyStage((DtoReplyStage)new DtoResultStage());
        }
        return this.getProtocol().get(PATH_RESUME, null, params, Response.class);
    }

    public ResponseResume resumePost(Outcome outcome) throws GearsServiceException {
        RequestResume reqResume = new RequestResume(this.getHandle(), (Object)outcome);
        this.setReplyStage((DtoReplyStage)new DtoResultStage());
        return this.getProtocol().postJson(PATH_RESUME, null, this.createParameters(), reqResume, ResponseResume.class);
    }

    protected void setLinks(Map<String, String> links) {
        this.links = links;
    }

    protected void setReplyStage(DtoReplyStage replyStage) {
        this.replyStage = replyStage;
    }
}

