/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.client.auth;

import de.intarsys.cloudsuite.gears.core.client.auth.CommonAuthenticator;
import jakarta.ws.rs.client.Invocation;
import java.util.Base64;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosAuthenticator
extends CommonAuthenticator {
    private static final Logger Log = LoggerFactory.getLogger(KerberosAuthenticator.class);
    private static Oid OID_SPNEGO;
    private String host;

    @Override
    public Invocation.Builder process(Invocation.Builder builder) {
        GSSManager manager = GSSManager.getInstance();
        try {
            GSSName name = manager.createName("HTTP@" + this.host, GSSName.NT_HOSTBASED_SERVICE);
            GSSCredential cred = manager.createCredential(name, 0, OID_SPNEGO, 2);
            GSSContext context = manager.createContext(name, OID_SPNEGO, cred, 0);
            byte[] token = context.initSecContext(new byte[0], 0, 0);
            builder.header("Authorization", (Object)("Negotiate " + Base64.getEncoder().encodeToString(token)));
        }
        catch (GSSException ex) {
            Log.warn(ex.getMessage(), (Throwable)ex);
        }
        return builder;
    }

    static {
        try {
            OID_SPNEGO = new Oid("1.3.6.1.5.5.2");
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
    }
}

