/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.card;

import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ATR {
    public static final byte[] ATR_INTERFACE_CONTACTLESS = HexTools.hexStringToBytes((String)"8001");
    private final byte[] atr;
    private List<ATRComponent> components = new ArrayList<ATRComponent>();
    private int historicalCharactersOffset;
    private int tck = -1;

    public static ATR create(byte[] atr) {
        if (atr == null) {
            return null;
        }
        return new ATR(atr);
    }

    public ATR(byte[] fullAtr) {
        assert (fullAtr != null);
        this.atr = fullAtr;
        this.historicalCharactersOffset = 1;
        boolean tdNextPresent = true;
        while (tdNextPresent) {
            byte tdi = this.atr[this.historicalCharactersOffset];
            tdNextPresent = (tdi & 0x80) != 0;
            int chunkLength = 0;
            if ((tdi & 0x80) != 0) {
                ++chunkLength;
            }
            if ((tdi & 0x40) != 0) {
                ++chunkLength;
            }
            if ((tdi & 0x20) != 0) {
                ++chunkLength;
            }
            if ((tdi & 0x10) != 0) {
                ++chunkLength;
            }
            this.historicalCharactersOffset += chunkLength;
        }
        ++this.historicalCharactersOffset;
        if (this.getHistoricalBytesSize() + this.getHistoricalBytesOffset() < this.atr.length) {
            this.tck = this.atr[this.getHistoricalBytesSize() + this.getHistoricalBytesOffset()];
        }
    }

    public boolean equals(byte[] other) {
        byte[] compare2;
        byte[] compare1;
        if (this.atr.length == other.length) {
            compare1 = this.atr;
            compare2 = other;
        } else {
            byte[] workaround;
            if (this.atr.length > other.length) {
                compare1 = other;
                workaround = this.atr;
            } else {
                compare1 = this.atr;
                workaround = other;
            }
            compare2 = new byte[compare1.length];
            System.arraycopy(workaround, 0, compare2, 0, compare2.length);
        }
        return Arrays.equals(compare1, compare2);
    }

    public boolean equals(Object other) {
        boolean result = super.equals(other);
        if (!result) {
            if (other instanceof byte[]) {
                return this.equals((byte[])other);
            }
            if (other instanceof ATR) {
                return this.equals(((ATR)other).getBytes());
            }
        }
        return result;
    }

    public byte[] getBytes() {
        return (byte[])this.atr.clone();
    }

    public int getCategoryIndicator() {
        if (this.getHistoricalBytesSize() == 0) {
            return 255;
        }
        return this.atr[this.historicalCharactersOffset];
    }

    public int getDataCodingByte() {
        return 0;
    }

    public byte[] getHistoricalBytes() {
        byte[] hist = new byte[this.getHistoricalBytesSize()];
        System.arraycopy(this.atr, this.historicalCharactersOffset, hist, 0, hist.length);
        return hist;
    }

    public int getHistoricalBytesOffset() {
        return this.historicalCharactersOffset;
    }

    public int getHistoricalBytesSize() {
        return this.atr[1] & 0xF;
    }

    public byte[] getInterfaceBytes() {
        int count = this.getHistoricalBytesOffset() - 2;
        byte[] result = new byte[count];
        System.arraycopy(this.atr, 2, result, 0, result.length);
        return result;
    }

    public int getInterfaceBytesOffset() {
        return 2;
    }

    public int getInterfaceBytesSize() {
        return this.getHistoricalBytesOffset() - 2;
    }

    public int getLcs() {
        return 0;
    }

    public int getSupportedLogicalChannels() {
        return 0;
    }

    public int getSupportedSelectionMethods() {
        return 0;
    }

    public int getT0() {
        return this.atr[1];
    }

    public int getTck() {
        return this.tck;
    }

    public int getTs() {
        return this.atr[0];
    }

    public int hashCode() {
        return Arrays.hashCode(this.atr);
    }

    public boolean isContactless() {
        return Arrays.equals(this.getInterfaceBytes(), ATR_INTERFACE_CONTACTLESS);
    }

    public boolean isDirectConvention() {
        return (this.atr[0] & 0x3B) == 59;
    }

    public boolean isInverseConvention() {
        return (this.atr[0] & 0x3F) == 63;
    }

    public boolean isTa1Available() {
        return (this.atr[1] & 0x10) == 16;
    }

    public boolean isTb1Available() {
        return (this.atr[1] & 0x20) == 32;
    }

    public boolean isTc1Available() {
        return (this.atr[1] & 0x40) == 64;
    }

    public boolean isTd1Available() {
        return (this.atr[1] & 0x80) == 128;
    }

    protected void parse() {
        boolean tdiPresent;
        if (this.components.size() > 0) {
            return;
        }
        int offset = 0;
        int interfaceIndex = 0;
        int length = 1;
        ATRComponent component = new ATRComponent("TS", offset, length);
        offset += length;
        this.components.add(component);
        int value = component.getValueInt();
        component.description = value == 59 ? component.description + "Direct convention" : (value == 63 ? component.description + "Inverse convention" : component.description + "Unknown convention");
        length = 1;
        component = new ATRComponent("T0", offset, length);
        offset += length;
        this.components.add(component);
        value = component.getValueInt();
        int historicalCount = value & 0xF;
        component.description = "Format Byte<br>";
        ++interfaceIndex;
        boolean taiPresent = (value & 0x10) == 16;
        boolean tbiPresent = (value & 0x20) == 32;
        boolean tciPresent = (value & 0x40) == 64;
        boolean bl = tdiPresent = (value & 0x80) == 128;
        if (taiPresent) {
            component.description = component.description + "TA" + interfaceIndex + " available<br>";
        }
        if (tbiPresent) {
            component.description = component.description + "TB" + interfaceIndex + " available<br>";
        }
        if (tciPresent) {
            component.description = component.description + "TC" + interfaceIndex + " available<br>";
        }
        if (tdiPresent) {
            component.description = component.description + "TD" + interfaceIndex + " available<br>";
        }
        component.description = component.description + historicalCount + " historical bytes";
        while (taiPresent || tbiPresent || tciPresent || tdiPresent) {
            if (taiPresent) {
                length = 1;
                component = new ATRComponent("TA" + interfaceIndex, offset, length);
                offset += length;
                this.components.add(component);
                value = component.getValueInt();
                taiPresent = false;
            }
            if (tbiPresent) {
                length = 1;
                component = new ATRComponent("TB" + interfaceIndex, offset, length);
                offset += length;
                this.components.add(component);
                value = component.getValueInt();
                tbiPresent = false;
            }
            if (tciPresent) {
                length = 1;
                component = new ATRComponent("TC" + interfaceIndex, offset, length);
                offset += length;
                this.components.add(component);
                value = component.getValueInt();
                tciPresent = false;
            }
            if (!tdiPresent) continue;
            length = 1;
            component = new ATRComponent("TD" + interfaceIndex, offset, length);
            offset += length;
            this.components.add(component);
            value = component.getValueInt();
            ++interfaceIndex;
            taiPresent = (value & 0x10) == 16;
            tbiPresent = (value & 0x20) == 32;
            tciPresent = (value & 0x40) == 64;
            boolean bl2 = tdiPresent = (value & 0x80) == 128;
            if (taiPresent) {
                component.description = component.description + "TA" + interfaceIndex + " available<br>";
            }
            if (tbiPresent) {
                component.description = component.description + "TB" + interfaceIndex + " available<br>";
            }
            if (tciPresent) {
                component.description = component.description + "TC" + interfaceIndex + " available<br>";
            }
            if (!tdiPresent) continue;
            component.description = component.description + "TD" + interfaceIndex + " available<br>";
        }
        if (historicalCount > 0) {
            length = historicalCount;
            component = new ATRComponent("Historical Bytes", offset, length);
            offset += length;
            this.components.add(component);
        }
        if (offset < this.atr.length) {
            length = 1;
            component = new ATRComponent("TCK", offset, length);
            offset += length;
            this.components.add(component);
        }
    }

    public String print() {
        return HexTools.bytesToHexString((byte[])this.atr);
    }

    public boolean supportsBerTlvFF() {
        return true;
    }

    public boolean supportsCommandChaining() {
        return true;
    }

    public boolean supportsExtendedLength() {
        return true;
    }

    public boolean supportsShortEfIdentifier() {
        return true;
    }

    public String toString() {
        return HexTools.bytesToHexString((byte[])this.atr);
    }

    public String toStringDetail() {
        this.parse();
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<table border=\"1\" >");
        sb.append("\t\t<tr>");
        sb.append("\t\t\t<td>");
        sb.append("\t\t\t\tATR");
        sb.append("\t\t\t</td>");
        sb.append("\t\t\t<td>");
        sb.append(HexTools.bytesToHexString((byte[])this.atr));
        sb.append("\t\t\t</td>");
        sb.append("\t\t</tr>");
        for (ATRComponent component : this.components) {
            sb.append("\t\t<tr>");
            sb.append("\t\t\t<td>");
            sb.append(component.label);
            sb.append("\t\t\t</td>");
            sb.append("\t\t\t<td>");
            sb.append(HexTools.bytesToHexString((byte[])component.getValueArray()));
            sb.append("\t\t\t</td>");
            sb.append("\t\t</tr>");
            if (StringTools.isEmpty((String)component.description)) continue;
            sb.append("\t\t<tr>");
            sb.append("\t\t\t<td>");
            sb.append("\t\t\t</td>");
            sb.append("\t\t\t<td>");
            sb.append(component.description);
            sb.append("\t\t\t</td>");
            sb.append("\t\t</tr>");
        }
        sb.append("</table>");
        sb.append("</html>");
        return sb.toString();
    }

    class ATRComponent {
        public String label = "";
        public String description = "";
        public int offset;
        public int length;

        public ATRComponent(String label, int offset, int length) {
            this.label = label;
            this.offset = offset;
            this.length = length;
        }

        public byte[] getValueArray() {
            return ByteArrayTools.copy((byte[])ATR.this.atr, (int)this.offset, (int)this.length);
        }

        public int getValueInt() {
            return Byte.toUnsignedInt(ATR.this.atr[this.offset]);
        }
    }
}

