/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.card;

import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.CommonCardConnectionMonitor;
import de.intarsys.security.smartcard.card.EnumCardState;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.ICardSystem;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.security.smartcard.card.PACKAGE;
import de.intarsys.tools.concurrent.TaskFailed;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.message.IMessageBundle;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveCardConnectionMonitor
extends CommonCardConnectionMonitor {
    private static final Logger Log = LoggerFactory.getLogger(ActiveCardConnectionMonitor.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private final EventDispatcher dispatcher = new EventDispatcher((Object)this);
    private ICardTerminal activeCardTerminal;
    private String activeCardStateMessage;
    private ICardConnection activeCardConnection;

    public ActiveCardConnectionMonitor(ICardSystem cardSystem) {
        super(cardSystem);
    }

    protected void acceptConnection(ICardConnection connection) throws Exception {
        this.activeCardTerminal = connection.getCardTerminal();
        this.activeCardConnection = connection;
        this.activeCardStateMessage = this.getCardConnectedMessage();
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.addNotificationListener(type, listener);
    }

    protected State createState() {
        return new State(Arrays.asList(this.getCardSystem().getCardTerminals()), this.activeCardTerminal, this.activeCardConnection, this.activeCardStateMessage);
    }

    protected ICardConnection getActiveCardConnection() {
        return this.activeCardConnection;
    }

    protected String getActiveCardStateMessage() {
        return this.activeCardStateMessage;
    }

    protected ICardTerminal getActiveCardTerminal() {
        return this.activeCardTerminal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        Object object = this.lock;
        synchronized (object) {
            return this.createState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onCardInserted(ICard card) {
        State state;
        super.onCardInserted(card);
        Object object = this.lock;
        synchronized (object) {
            if (this.activeCardConnection != null) {
                return;
            }
            this.select(card.getCardTerminal());
            state = this.createState();
        }
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)"state", null, (Object)state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onCardRemoved(ICard card) {
        State state;
        super.onCardRemoved(card);
        Object object = this.lock;
        synchronized (object) {
            if (this.activeCardConnection == null || card != this.activeCardConnection.getCard()) {
                return;
            }
            this.select(card.getCardTerminal());
            state = this.createState();
        }
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)"state", null, (Object)state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onCardTerminalConnected(ICardTerminal terminal) {
        State state;
        super.onCardTerminalConnected(terminal);
        Object object = this.lock;
        synchronized (object) {
            if (this.activeCardTerminal == null) {
                this.select(terminal);
            }
            state = this.createState();
        }
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)"state", null, (Object)state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onCardTerminalDisconnected(ICardTerminal terminal) {
        State state;
        super.onCardTerminalDisconnected(terminal);
        Object object = this.lock;
        synchronized (object) {
            if (this.activeCardTerminal == terminal) {
                ICardTerminal[] terminals = this.getCardSystem().getCardTerminals();
                if (terminals.length == 0) {
                    this.select(null);
                } else {
                    this.select(terminals[0]);
                }
            }
            state = this.createState();
        }
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)"state", null, (Object)state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onConnected(ICardConnection connection) throws CardException {
        State state;
        Object object = this.lock;
        synchronized (object) {
            if (this.activeCardConnection != null) {
                Log.trace("{} ignore {}", this.getLogPrefix(), (Object)connection);
                try {
                    connection.close(0);
                }
                catch (CardException cardException) {
                    // empty catch block
                }
                return;
            }
            Log.trace("{} {} established", this.getLogPrefix(), (Object)connection);
            try {
                this.acceptConnection(connection);
            }
            catch (Exception e) {
                CardException nested = (CardException)ExceptionTools.getFromChain((Throwable)e, CardException.class);
                if (nested != null) {
                    throw nested;
                }
                throw CardException.create(e);
            }
            state = this.createState();
        }
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)"state", null, (Object)state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onConnectedGiveup(ICardConnection connection) {
        State state;
        super.onConnectedGiveup(connection);
        Object object = this.lock;
        synchronized (object) {
            this.activeCardStateMessage = this.getCardUnsupportedMessage();
            state = this.createState();
        }
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)"state", null, (Object)state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onConnectionFailed(ICard card, TaskFailed exception) {
        State state;
        Object object = this.lock;
        synchronized (object) {
            if (this.activeCardConnection != null) {
                Log.trace("{} {} connect failure ignored", this.getLogPrefix(), (Object)card);
                return;
            }
            this.activeCardStateMessage = this.getCardConnectionFailedMessage(exception);
            state = this.createState();
        }
        Log.debug("{} {} connect failed", new Object[]{this.getLogPrefix(), card, exception});
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)"state", null, (Object)state));
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    protected void resetConnection() {
        if (this.activeCardConnection != null) {
            try {
                this.activeCardConnection.close(0);
            }
            catch (CardException e) {
                Log.warn("{} {} disconnect failed", this.getLogPrefix(), (Object)this.activeCardConnection);
            }
        }
        this.activeCardConnection = null;
    }

    protected void select(ICardTerminal cardTerminal) {
        EnumCardState state;
        this.activeCardTerminal = cardTerminal;
        ICard card = cardTerminal == null ? null : cardTerminal.getCard();
        Log.trace("{} select {}, {}", new Object[]{this.getLogPrefix(), cardTerminal, card});
        this.activeCardStateMessage = this.getCardStateMessage(card);
        this.resetConnection();
        if (card != null && this.isStarted() && ((state = card.getState()).isConnectedShared() || state.isNotConnected())) {
            this.activeCardStateMessage = this.getCardConnectingMessage();
            this.connect(card);
        }
    }

    protected void setActiveCardConnection(ICardConnection activeCardConnection) {
        this.activeCardConnection = activeCardConnection;
    }

    protected void setActiveCardStateMessage(String activeCardStateMessage) {
        this.activeCardStateMessage = activeCardStateMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveCardTerminal(ICardTerminal newActiveTerminal) {
        State state;
        Object object = this.lock;
        synchronized (object) {
            if (newActiveTerminal == null || newActiveTerminal.isDisposed() || this.activeCardTerminal == newActiveTerminal) {
                return;
            }
            this.select(newActiveTerminal);
            state = this.createState();
        }
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)"state", null, (Object)state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        Object object = this.lock;
        synchronized (object) {
            this.select(null);
        }
    }

    protected void triggerEvent(Event event) {
        if (!this.isStarted()) {
            return;
        }
        this.dispatcher.triggerEvent(event);
    }

    public static class State {
        private final List<ICardTerminal> cardTerminals;
        private final String activeCardStateMessage;
        private final ICardTerminal activeCardTerminal;
        private final ICardConnection activeCardConnection;

        public State(List<ICardTerminal> cardTerminals, ICardTerminal activeCardTerminal, ICardConnection connection, String cardStateMessage) {
            this.cardTerminals = cardTerminals;
            this.activeCardConnection = connection;
            this.activeCardStateMessage = cardStateMessage;
            this.activeCardTerminal = activeCardTerminal;
        }

        public ICardConnection getActiveCardConnection() {
            return this.activeCardConnection;
        }

        public String getActiveCardStateMessage() {
            return this.activeCardStateMessage;
        }

        public ICardTerminal getActiveCardTerminal() {
            return this.activeCardTerminal;
        }

        public List<ICardTerminal> getCardTerminals() {
            return this.cardTerminals;
        }
    }
}

