/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.card;

import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.CardSystem;
import de.intarsys.security.smartcard.card.CardTools;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.ICardConnectionFilter;
import de.intarsys.security.smartcard.card.ICardSystem;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardConnectionDetector<R extends Result> {
    private static final Logger Log = LoggerFactory.getLogger(CardConnectionDetector.class);
    private List<ICardTerminal> cardTerminals;
    private ICardConnectionFilter cardChannelFilter;
    private int connectionTimeout = 5000;
    private boolean closeConnection = true;

    public void addCardTerminal(ICardTerminal terminal) {
        if (this.cardTerminals == null) {
            this.cardTerminals = new ArrayList<ICardTerminal>(3);
        }
        this.cardTerminals.add(terminal);
    }

    public void addCardTerminal(String name) {
        ICardTerminal terminal = CardSystem.get().getCardTerminal(name);
        if (terminal != null) {
            this.addCardTerminal(terminal);
        }
    }

    public List<R> findAll() {
        return this.findForTerminals(false);
    }

    public R findFirst() {
        List<R> result = this.findForTerminals(true);
        if (result == null || result.size() == 0) {
            return null;
        }
        return (R)((Result)result.get(0));
    }

    protected List<R> findForConnection(ICardConnection connection) {
        return ListTools.with((Object[])new Result[]{new Result(connection)});
    }

    protected List<R> findForTerminal(ICardTerminal terminal) {
        ICardConnection connection = null;
        ICard card = terminal.getCard();
        try {
            List<R> result = null;
            connection = CardTools.connectTransacted(card, this.getConnectionTimeout());
            if (this.getCardChannelFilter() == null) {
                result = this.findForConnection(connection);
            } else if (this.getCardChannelFilter().accept(connection)) {
                result = this.findForConnection(connection);
            }
            if (result == null || result.isEmpty() || this.isCloseConnection()) {
                connection.close(0);
            }
            return result;
        }
        catch (Exception ex) {
            boolean retry;
            if (connection != null) {
                try {
                    connection.close(1);
                }
                catch (CardException e) {
                    Log.debug("close failed");
                }
            }
            if (retry = CardTools.isRetry(card, ex, 0)) {
                return this.findForTerminal(terminal);
            }
            Log.trace("{}: {}", new Object[]{this, ExceptionTools.getMessage((Throwable)ex), ex});
            return null;
        }
    }

    protected List<R> findForTerminals(boolean returnFirst) {
        List<ICardTerminal> searchTerminals = this.cardTerminals;
        if (searchTerminals == null || searchTerminals.isEmpty()) {
            ICardSystem cardSystem = CardSystem.get();
            ICardTerminal[] terminals = cardSystem.getCardTerminals();
            searchTerminals = Arrays.asList(terminals);
        }
        return this.findForTerminals(searchTerminals, returnFirst);
    }

    protected List<R> findForTerminals(List<ICardTerminal> terminals, boolean returnFirst) {
        ArrayList<R> allResults = new ArrayList<R>(terminals.size());
        for (ICardTerminal terminal : terminals) {
            List<R> result;
            if (terminal.getCard() == null || (result = this.findForTerminal(terminal)) == null) continue;
            allResults.addAll(result);
            if (!returnFirst) continue;
            break;
        }
        return allResults;
    }

    public ICardConnectionFilter getCardChannelFilter() {
        return this.cardChannelFilter;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public boolean isCloseConnection() {
        return this.closeConnection;
    }

    public void removeCardTerminal(ICardTerminal removeTerminal) {
        if (removeTerminal == null || this.cardTerminals == null) {
            return;
        }
        this.cardTerminals.remove(removeTerminal);
    }

    public void removeCardTerminalName(String removeTerminalName) {
        if (StringTools.isEmpty((String)removeTerminalName) || this.cardTerminals == null) {
            return;
        }
        for (ICardTerminal terminal : this.cardTerminals) {
            if (!terminal.getName().equals(removeTerminalName)) continue;
            this.cardTerminals.remove(terminal);
            break;
        }
    }

    public void setCardChannelFilter(ICardConnectionFilter cardConnectionFilter) {
        this.cardChannelFilter = cardConnectionFilter;
    }

    public void setCloseConnection(boolean closeConnection) {
        this.closeConnection = closeConnection;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public static class Result {
        private final ICardConnection cardChannel;

        public Result(ICardConnection connection) {
            this.cardChannel = connection;
        }

        public ICardConnection getCardConnection() {
            return this.cardChannel;
        }
    }
}

