/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.card;

import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.CommonCardConnectionMonitor;
import de.intarsys.security.smartcard.card.EnumCardState;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.ICardSystem;
import de.intarsys.tools.concurrent.ITaskCallback;
import de.intarsys.tools.concurrent.TaskFailed;
import de.intarsys.tools.exception.ExceptionTools;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardConnectionMonitor
extends CommonCardConnectionMonitor {
    private static final Logger Log = LoggerFactory.getLogger(CardConnectionMonitor.class);
    private final List<ITaskCallback<ICardConnection>> listeners = new ArrayList<ITaskCallback<ICardConnection>>();
    private boolean closeConnection = false;

    public CardConnectionMonitor(ICardSystem cardSystem) {
        super(cardSystem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCardConnectionListener(ITaskCallback<ICardConnection> listener) {
        List<ITaskCallback<ICardConnection>> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    public boolean isCloseConnection() {
        return this.closeConnection;
    }

    @Override
    protected void onCardInserted(ICard card) {
        super.onCardInserted(card);
        EnumCardState state = card.getState();
        if (state.isConnectedShared() || state.isNotConnected()) {
            this.connect(card);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onConnected(ICardConnection connection) throws CardException {
        ArrayList<ITaskCallback<ICardConnection>> tempListeners;
        List<ITaskCallback<ICardConnection>> list = this.listeners;
        synchronized (list) {
            tempListeners = new ArrayList<ITaskCallback<ICardConnection>>(this.listeners);
        }
        boolean close = this.isCloseConnection();
        try {
            for (ITaskCallback iTaskCallback : tempListeners) {
                iTaskCallback.finished((Object)connection);
            }
        }
        catch (RuntimeException e) {
            close = true;
            CardException cardException = (CardException)ExceptionTools.getFromChain((Throwable)e, CardException.class);
            if (cardException != null) {
                throw cardException;
            }
            throw e;
        }
        finally {
            if (close) {
                try {
                    connection.close(0);
                }
                catch (CardException e) {
                    Log.warn("{} close {} failed", this.getLogPrefix(), (Object)connection);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onConnectionFailed(ICard card, TaskFailed exception) {
        ArrayList<ITaskCallback<ICardConnection>> tempListeners;
        List<ITaskCallback<ICardConnection>> list = this.listeners;
        synchronized (list) {
            tempListeners = new ArrayList<ITaskCallback<ICardConnection>>(this.listeners);
        }
        for (ITaskCallback iTaskCallback : tempListeners) {
            iTaskCallback.failed(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCardConnectionListener(ITaskCallback<ICardConnection> listener) {
        List<ITaskCallback<ICardConnection>> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public void setCloseConnection(boolean closeConnection) {
        this.closeConnection = closeConnection;
    }
}

