/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.card;

import de.intarsys.security.smartcard.card.CardReset;
import de.intarsys.security.smartcard.card.CardSharingViolation;
import de.intarsys.security.smartcard.card.CardUnavailable;
import de.intarsys.security.smartcard.pcsc.PCSCCardReset;
import de.intarsys.security.smartcard.pcsc.PCSCCardUnavailable;
import de.intarsys.security.smartcard.pcsc.PCSCSharingViolation;

public class CardException
extends Exception {
    private static final long serialVersionUID = 1L;

    public static CardException create(String message, Throwable e) {
        if (e instanceof CardException) {
            return (CardException)e;
        }
        if (e instanceof PCSCCardReset) {
            return new CardReset();
        }
        if (e instanceof PCSCSharingViolation) {
            return new CardSharingViolation();
        }
        if (e instanceof PCSCCardUnavailable) {
            return new CardUnavailable(e.getMessage(), e);
        }
        return new CardException(message, e);
    }

    public static CardException create(Throwable e) {
        if (e instanceof CardException) {
            return (CardException)e;
        }
        if (e instanceof PCSCCardReset) {
            return new CardReset();
        }
        if (e instanceof PCSCSharingViolation) {
            return new CardSharingViolation();
        }
        if (e instanceof PCSCCardUnavailable) {
            return new CardUnavailable(e.getMessage(), e);
        }
        return new CardException(e.getLocalizedMessage(), e);
    }

    public CardException() {
    }

    public CardException(String message) {
        super(message);
    }

    public CardException(String message, Throwable cause) {
        super(message, cause);
    }
}

