/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.card;

import de.intarsys.security.smartcard.card.CardEvent;
import de.intarsys.security.smartcard.card.EnumCardState;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardSystem;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.security.smartcard.card.PACKAGE;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.concurrent.TaskFailed;
import de.intarsys.tools.concurrent.ThreadTools;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reflect.ObjectTools;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardSystemMonitor {
    private static final Logger Log = LoggerFactory.getLogger(CardSystemMonitor.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private final ScheduledExecutorService eventExecutor;
    private final ICardSystem cardSystem;
    private final String label;
    private final List<ICardSystemListener> listeners = new CopyOnWriteArrayList<ICardSystemListener>();
    private final INotificationListener<CardEvent> listenCardEvents = new INotificationListener<CardEvent>(){

        public void handleEvent(final CardEvent event) {
            if (!CardSystemMonitor.this.isStarted()) {
                return;
            }
            CardSystemMonitor.this.getEventExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    if (!CardSystemMonitor.this.isStarted()) {
                        return;
                    }
                    CardSystemMonitor.this.onCardUpdate(event.getCard(), event.getNewState());
                }
            });
        }
    };
    private final INotificationListener<AttributeChangedEvent> listenCardSystemChanged = new INotificationListener<AttributeChangedEvent>(){

        public void handleEvent(final AttributeChangedEvent event) {
            if (!CardSystemMonitor.this.isStarted()) {
                return;
            }
            CardSystemMonitor.this.getEventExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    if (!CardSystemMonitor.this.isStarted()) {
                        return;
                    }
                    Object value = event.getOldValue();
                    if (value instanceof ICardTerminal) {
                        CardSystemMonitor.this.onCardTerminalDisconnect((ICardTerminal)value);
                    }
                    if ((value = event.getNewValue()) instanceof ICardTerminal) {
                        CardSystemMonitor.this.onCardTerminalConnect((ICardTerminal)value);
                    }
                }
            });
        }
    };
    protected final Object lock = new Object();
    private boolean started = false;
    private final Attribute attrSeen = new Attribute("seen");

    public CardSystemMonitor(ICardSystem cardSystem) {
        this.label = ObjectTools.createLabel((Object)this);
        this.cardSystem = cardSystem;
        this.eventExecutor = Executors.newSingleThreadScheduledExecutor(ThreadTools.newThreadFactoryDaemon((String)this.toString()));
    }

    public CardSystemMonitor(ICardSystem cardSystem, ScheduledExecutorService executor) {
        this.label = ObjectTools.createLabel((Object)this);
        this.cardSystem = cardSystem;
        this.eventExecutor = executor;
    }

    public void addCardSystemListener(ICardSystemListener listener) {
        this.listeners.add(listener);
    }

    protected boolean checkSeen(ICard card) {
        Boolean seen = this.getSeen(card);
        if (seen == null || !seen.booleanValue()) {
            this.setSeen(card, true);
            return false;
        }
        return true;
    }

    public void dispose() {
        this.stop();
        this.getEventExecutor().shutdownNow();
    }

    protected String getCardConnectedMessage() {
        return Msg.getString("CardSystemMonitor.stateConnected", new Object[0]);
    }

    protected String getCardConnectingMessage() {
        return Msg.getString("CardSystemMonitor.stateConnecting", new Object[0]);
    }

    protected String getCardConnectionFailedMessage(TaskFailed exception) {
        if (exception.isCancellation()) {
            return Msg.getString("CardSystemMonitor.stateConnectedFailedCancel", new Object[0]);
        }
        String msg = exception.getCause().getLocalizedMessage();
        if (msg == null || "null".equals(msg)) {
            return Msg.getString("CardSystemMonitor.stateConnectedFailedUnspecified", new Object[0]);
        }
        return Msg.getString("CardSystemMonitor.stateConnectedFailed", new Object[]{msg});
    }

    protected String getCardStateMessage(ICard card) {
        if (card == null) {
            return Msg.getString("CardSystemMonitor.stateNoCardAvailable", new Object[0]);
        }
        EnumCardState state = card.getState();
        if (state.isInvalid()) {
            return Msg.getString("CardSystemMonitor.stateNoCardAvailable", new Object[0]);
        }
        if (state.isConnectedExclusive()) {
            return Msg.getString("CardSystemMonitor.stateConnectedExclusive", new Object[0]);
        }
        if (state.isConnectedShared() || state.isNotConnected()) {
            return Msg.getString("CardSystemMonitor.stateNotConnected", new Object[0]);
        }
        return "";
    }

    public ICardSystem getCardSystem() {
        return this.cardSystem;
    }

    protected String getCardUnsupportedMessage() {
        return Msg.getString("CardSystemMonitor.unsupportedCard", new Object[0]);
    }

    protected ScheduledExecutorService getEventExecutor() {
        return this.eventExecutor;
    }

    protected Object getLogPrefix() {
        return this.label;
    }

    protected Boolean getSeen(ICard card) {
        return (Boolean)card.getAttribute(this.attrSeen);
    }

    public boolean isCardAvailable() {
        for (ICardTerminal terminal : this.getCardSystem().getCardTerminals()) {
            if (terminal.getCard() == null) continue;
            return true;
        }
        return false;
    }

    public boolean isCardTerminalAvailable() {
        return this.getCardSystem().getCardTerminals().length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.lock;
        synchronized (object) {
            return this.started;
        }
    }

    protected void onCardChanged(ICard card) {
        for (ICardSystemListener listener : this.listeners) {
            listener.onCardChanged(card);
        }
    }

    protected void onCardInserted(ICard card) {
        Log.debug("{} {} inserted", this.getLogPrefix(), (Object)card);
        for (ICardSystemListener listener : this.listeners) {
            listener.onCardInserted(card);
        }
    }

    protected void onCardRemoved(ICard card) {
        Log.debug("{} {} removed", this.getLogPrefix(), (Object)card);
        for (ICardSystemListener listener : this.listeners) {
            listener.onCardRemoved(card);
        }
    }

    protected void onCardTerminalConnect(ICardTerminal terminal) {
        if (terminal.isDisposed()) {
            return;
        }
        Log.info("{} {} connected", this.getLogPrefix(), (Object)terminal);
        for (ICardSystemListener listener : this.listeners) {
            listener.onCardTerminalConnected(terminal);
        }
        this.onCardTerminalConnected(terminal);
        terminal.addNotificationListener(CardEvent.ID, this.listenCardEvents);
        ICard card = terminal.getCard();
        if (card != null) {
            this.onCardUpdate(card, card.getState());
        }
    }

    protected void onCardTerminalConnected(ICardTerminal terminal) {
    }

    protected void onCardTerminalDisconnect(ICardTerminal terminal) {
        Log.info("{} {} disconnected", this.getLogPrefix(), (Object)terminal);
        for (ICardSystemListener listener : this.listeners) {
            listener.onCardTerminalDisconnected(terminal);
        }
        this.onCardTerminalDisconnected(terminal);
        terminal.removeNotificationListener(CardEvent.ID, this.listenCardEvents);
    }

    protected void onCardTerminalDisconnected(ICardTerminal terminal) {
    }

    protected void onCardUpdate(ICard card, EnumCardState state) {
        if (state.isInvalid()) {
            this.onCardRemoved(card);
        } else if (this.checkSeen(card)) {
            this.onCardChanged(card);
        } else {
            this.onCardInserted(card);
        }
    }

    protected void onStarted() {
    }

    public void removeCardSystemListener(ICardSystemListener listener) {
        this.listeners.remove(listener);
    }

    protected void setSeen(ICard card, boolean value) {
        card.setAttribute(this.attrSeen, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            ICardTerminal[] tempTerminals = this.cardSystem.getCardTerminals();
            this.started = true;
            Log.info("{} start", this.getLogPrefix());
            this.cardSystem.addNotificationListener(AttributeChangedEvent.ID, this.listenCardSystemChanged);
            for (final ICardTerminal cardTerminal : tempTerminals) {
                this.getEventExecutor().submit(new Runnable(){

                    @Override
                    public void run() {
                        if (!CardSystemMonitor.this.isStarted()) {
                            return;
                        }
                        CardSystemMonitor.this.onCardTerminalConnect(cardTerminal);
                    }
                });
            }
            this.getEventExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    CardSystemMonitor.this.onStarted();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.started = false;
            Log.info("{} stop", this.getLogPrefix());
            this.cardSystem.removeNotificationListener(AttributeChangedEvent.ID, this.listenCardSystemChanged);
            for (ICardTerminal cardTerminal : this.getCardSystem().getCardTerminals()) {
                cardTerminal.removeNotificationListener(CardEvent.ID, this.listenCardEvents);
                ICard card = cardTerminal.getCard();
                if (card == null) continue;
                this.setSeen(card, false);
            }
        }
    }

    public String toString() {
        return this.label;
    }

    public static interface ICardSystemListener {
        public void onCardChanged(ICard var1);

        public void onCardInserted(ICard var1);

        public void onCardRemoved(ICard var1);

        public void onCardTerminalConnected(ICardTerminal var1);

        public void onCardTerminalDisconnected(ICardTerminal var1);
    }
}

