/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.card;

import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.CardReset;
import de.intarsys.security.smartcard.card.CardUnavailable;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.concurrent.AbstractFutureTask;
import de.intarsys.tools.concurrent.ITaskCallback;
import de.intarsys.tools.concurrent.TaskFailed;
import de.intarsys.tools.concurrent.ThreadTools;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.oid.IOIDGenerator;
import de.intarsys.tools.oid.PronouncableOIDGenerator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class CardTools {
    private static final IOIDGenerator<String> OID_GENERATOR = new PronouncableOIDGenerator();
    protected static final long RETRY_DELAY = 200L;
    private static final Attribute ATTR_RetryCount = new Attribute("retryCount");
    private static final Attribute ATTR_RetryDelay = new Attribute("retryDelay");
    protected static final Logger Log = LoggerFactory.getLogger(CardTools.class);

    public static void beginTransaction(ICardConnection connection, int millisecTimeout) throws CardException, TimeoutException, InterruptedException {
        Future<Void> f = connection.beginTransaction(null);
        try {
            f.get(millisecTimeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            CardTools.cancel(f, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            CardTools.cancel(f, e);
        }
        catch (ExecutionException e) {
            throw CardException.create("begin transaction failed", ExceptionTools.unwrap((Throwable)e));
        }
    }

    protected static <T> T cancel(Future<T> f, Exception e) throws CardException, TimeoutException, InterruptedException {
        if (!f.cancel(false)) {
            try {
                return f.get(-1L, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException ex) {
                throw CardException.create(e.getCause());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (e instanceof TimeoutException) {
            throw (TimeoutException)e;
        }
        if (e instanceof InterruptedException) {
            throw (InterruptedException)e;
        }
        throw CardException.create(ExceptionTools.unwrap((Throwable)e));
    }

    public static ICardConnection connectShared(ICard card, int millisecTimeout) throws CardException, TimeoutException, InterruptedException {
        Future<ICardConnection> f = card.connectShared(3, null);
        try {
            return f.get(millisecTimeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            return CardTools.cancel(f, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return CardTools.cancel(f, e);
        }
        catch (ExecutionException e) {
            throw CardException.create(e.getCause());
        }
    }

    public static Future<ICardConnection> connectShared(ICard card, ITaskCallback<ICardConnection> callback) {
        return card.connectShared(3, callback);
    }

    public static ICardConnection connectTransacted(ICard card, int millisecTimeout) throws CardException, TimeoutException, InterruptedException {
        ICardConnection connection = CardTools.connectShared(card, millisecTimeout);
        try {
            CardTools.beginTransaction(connection, millisecTimeout);
            return connection;
        }
        catch (TimeoutException e) {
            connection.close(0);
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            connection.close(0);
            throw e;
        }
        catch (RuntimeException e) {
            connection.close(0);
            throw e;
        }
    }

    public static Future<ICardConnection> connectTransacted(ICard card, ITaskCallback<ICardConnection> callback) {
        ConnectTransactedTask task = new ConnectTransactedTask(card);
        if (callback != null) {
            task.addTaskCallback(callback);
        }
        task.run();
        return task;
    }

    public static ScheduledExecutorService createExecutor(String id) {
        return new ScheduledThreadPoolExecutor(1, ThreadTools.newThreadFactoryDaemon((String)id)){

            @Override
            public void execute(Runnable command) {
                Map contextMap = MDC.getCopyOfContextMap();
                super.execute(() -> {
                    Map previousContextMap = MDC.getCopyOfContextMap();
                    if (contextMap == null) {
                        MDC.clear();
                    } else {
                        MDC.setContextMap((Map)contextMap);
                    }
                    try {
                        command.run();
                    }
                    finally {
                        if (previousContextMap == null) {
                            MDC.clear();
                        } else {
                            MDC.setContextMap((Map)previousContextMap);
                        }
                    }
                });
            }
        };
    }

    public static String createId() {
        return (String)OID_GENERATOR.createOID();
    }

    public static boolean isRetry(ICard card, Throwable e, int maxRetries) {
        Long retryDelay;
        if (card == null) {
            return false;
        }
        boolean retry = false;
        boolean log = false;
        Integer retryCount = (Integer)card.getAttribute(ATTR_RetryCount);
        if (retryCount == null) {
            retryCount = maxRetries;
        }
        if ((retryDelay = (Long)card.getAttribute(ATTR_RetryDelay)) == null) {
            retryDelay = 200L;
        }
        if (ExceptionTools.isInChain((Throwable)e, CardReset.class)) {
            retry = true;
            log = true;
        } else if (ExceptionTools.isInChain((Throwable)e, CardUnavailable.class)) {
            retry = false;
            log = true;
        } else if (e != null && maxRetries > 0) {
            Integer n = retryCount;
            retryCount = retryCount - 1;
            card.setAttribute(ATTR_RetryCount, retryCount);
            retry = retryCount >= 0;
            log = true;
        }
        try {
            if (retry) {
                Thread.sleep(retryDelay);
                retryDelay = retryDelay * 2L;
                if (retryDelay > 60000L) {
                    retryDelay = 60000L;
                }
                card.setAttribute(ATTR_RetryDelay, retryDelay);
            }
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
        if (log) {
            Log.debug("{} retry {} ({})", new Object[]{card, retry ? "accept" : "deny", ExceptionTools.getMessage((Throwable)e)});
        }
        return retry;
    }

    public static boolean isRetryReset(ICard card, Throwable e) {
        boolean retry = false;
        if (ExceptionTools.isInChain((Throwable)e, CardReset.class)) {
            retry = true;
        }
        try {
            if (retry) {
                Thread.sleep(200L);
            }
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
        return retry;
    }

    public static void resetRetry(ICard card) {
        if (card == null) {
            return;
        }
        card.setAttribute(ATTR_RetryCount, null);
    }

    private CardTools() {
    }

    static class ConnectTransactedTask
    extends AbstractFutureTask<ICardConnection> {
        private Future<ICardConnection> cardConnectTask;
        private Future<Void> beginTransactionTask;
        private ICardConnection connection;
        private final ICard card;

        protected ConnectTransactedTask(ICard card) {
            this.card = card;
            this.setAsynch(true);
            this.created();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel(boolean interrupt) {
            boolean canceled = super.cancel(interrupt);
            ConnectTransactedTask connectTransactedTask = this;
            synchronized (connectTransactedTask) {
                if (this.beginTransactionTask != null) {
                    this.beginTransactionTask.cancel(false);
                }
                if (this.cardConnectTask != null) {
                    this.cardConnectTask.cancel(false);
                }
            }
            return canceled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ICardConnection compute() throws CardException {
            ConnectTransactedTask connectTransactedTask = this;
            synchronized (connectTransactedTask) {
                this.startCardConnectTask();
            }
            return null;
        }

        public ICard getCard() {
            return this.card;
        }

        private void onConnectFailed(Throwable t) {
            Log.debug("{} {} connect failed ({})", new Object[]{this.getLabel(), this.card, ExceptionTools.getMessage((Throwable)t)});
            this.setException(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onConnectSuccess(ICardConnection newCardChannel) {
            ConnectTransactedTask connectTransactedTask = this;
            synchronized (connectTransactedTask) {
                this.connection = newCardChannel;
            }
            if (this.isCancelled()) {
                this.setResult(null);
                return;
            }
            try {
                connectTransactedTask = this;
                synchronized (connectTransactedTask) {
                    this.startBeginTransactionTask();
                }
            }
            catch (RuntimeException e) {
                this.setException(new CardException("unexpected exception", e));
            }
        }

        private void onTransactionFailed(Throwable t) {
            Log.debug("{} {} transaction begin failed ({})", new Object[]{this.getLabel(), this.card, ExceptionTools.getMessage((Throwable)t)});
            this.setException(t);
        }

        private void onTransactionSuccess() {
            if (this.isCancelled()) {
                this.setResult(null);
                return;
            }
            try {
                this.setResult(this.connection);
            }
            catch (RuntimeException e) {
                this.setException(new CardException("unexpected exception", e));
            }
        }

        private void startBeginTransactionTask() {
            this.beginTransactionTask = this.connection.beginTransaction(new ITaskCallback<Void>(){

                public void failed(TaskFailed exception) {
                    if (!exception.isCancellation()) {
                        this.onTransactionFailed(exception.getCause());
                    }
                }

                public void finished(Void result) {
                    this.onTransactionSuccess();
                }
            });
        }

        private void startCardConnectTask() {
            this.cardConnectTask = this.getCard().connectShared(3, new ITaskCallback<ICardConnection>(){

                public void failed(TaskFailed exception) {
                    if (!exception.isCancellation()) {
                        this.onConnectFailed(exception.getCause());
                    }
                }

                public void finished(ICardConnection cardChannel) {
                    this.onConnectSuccess(cardChannel);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void taskFailed() {
            ConnectTransactedTask connectTransactedTask = this;
            synchronized (connectTransactedTask) {
                if (this.connection != null) {
                    try {
                        this.connection.close(0);
                    }
                    catch (CardException e) {
                        Log.trace("{} {} close failed ({})", new Object[]{this.getLabel(), this.connection, ExceptionTools.getMessage((Throwable)e)});
                    }
                }
            }
            super.taskFailed();
        }

        protected void undo() {
            this.undoAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void undoAll() {
            ConnectTransactedTask connectTransactedTask = this;
            synchronized (connectTransactedTask) {
                if (this.connection != null) {
                    try {
                        this.connection.close(0);
                    }
                    catch (CardException e) {
                        Log.trace("{} {} close failed ({})", new Object[]{this.getLabel(), this.connection, ExceptionTools.getMessage((Throwable)e)});
                    }
                }
            }
        }
    }
}

