/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.card;

import de.intarsys.security.smartcard.card.ATR;
import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.CardTools;
import de.intarsys.security.smartcard.card.CardUnavailable;
import de.intarsys.security.smartcard.card.CommonCardConnection;
import de.intarsys.security.smartcard.card.CommonCardTerminal;
import de.intarsys.security.smartcard.card.EnumCardState;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.concurrent.AbstractFutureTask;
import de.intarsys.tools.concurrent.ITaskCallback;
import de.intarsys.tools.exception.ExceptionTools;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonCard
implements ICard {
    private static final Logger Log = LoggerFactory.getLogger(CommonCard.class);
    private final ATR atr;
    private final AttributeMap attributeMap = new AttributeMap();
    private final CommonCardTerminal cardTerminal;
    protected final Object lock = new Object();
    private EnumCardState cardState;
    private final String id;
    private List<CommonCardConnection> connections = new ArrayList<CommonCardConnection>();

    protected CommonCard(CommonCardTerminal cardTerminal, ATR atr) {
        assert (cardTerminal != null);
        assert (atr != null);
        this.cardTerminal = cardTerminal;
        this.id = cardTerminal.getId() + "-" + CardTools.createId();
        this.atr = atr;
        this.cardState = EnumCardState.UNKNOWN;
        Log.debug("{} with ATR '{}' in {} created", new Object[]{this.getLogLabel(), atr, cardTerminal});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addConnection(CommonCardConnection connection) throws CardException {
        Object object = this.lock;
        synchronized (object) {
            this.checkValidity();
            this.connections.add(connection);
        }
    }

    protected abstract CommonCardConnection basicConnectExclusive(String var1, int var2, ScheduledExecutorService var3) throws CardException;

    protected abstract CommonCardConnection basicConnectShared(String var1, int var2, ScheduledExecutorService var3) throws CardException;

    protected CommonCardTerminal basicGetCardTerminal() {
        return this.cardTerminal;
    }

    protected void checkValidity() throws CardException {
        if (this.cardState == EnumCardState.INVALID) {
            throw new CardUnavailable();
        }
        if (this.basicGetCardTerminal() != null) {
            this.basicGetCardTerminal().checkValidity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ICardConnection connectExclusive(int protocol) throws CardException {
        Object object = this.lock;
        synchronized (object) {
            this.checkValidity();
        }
        String suffix = CardTools.createId();
        String executorId = this.getId() + "-" + suffix;
        ScheduledExecutorService executor = CardTools.createExecutor(executorId);
        return this.basicConnectExclusive(suffix, protocol, executor);
    }

    public final ConnectTask connectShared(int protocol, ITaskCallback<ICardConnection> callback) {
        String suffix = CardTools.createId();
        String executorId = this.getId() + "-" + suffix;
        ScheduledExecutorService executor = CardTools.createExecutor(executorId);
        ConnectTask connectTask = new ConnectTask(suffix, protocol, executor);
        if (callback != null) {
            connectTask.addTaskCallback(callback);
        }
        executor.execute((Runnable)((Object)connectTask));
        return connectTask;
    }

    protected void dispose() {
        Log.debug("{} dispose", (Object)this.getLogLabel());
        List<CommonCardConnection> tempConnections = this.getConnections();
        for (CommonCardConnection connection : tempConnections) {
            try {
                connection.close(0);
            }
            catch (CardException e) {
                Log.trace("{} error disposing {}", (Object)this.getLogLabel(), (Object)connection);
            }
        }
        this.setState(EnumCardState.INVALID);
    }

    @Override
    public ATR getAtr() {
        return this.atr;
    }

    public Object getAttribute(Object key) {
        return this.attributeMap.getAttribute(key);
    }

    @Override
    public ICardTerminal getCardTerminal() {
        return this.cardTerminal;
    }

    protected List<CommonCardConnection> getConnections() {
        return new ArrayList<CommonCardConnection>(this.connections);
    }

    public String getId() {
        return this.id;
    }

    protected String getLogLabel() {
        return this.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnumCardState getState() {
        Object object = this.lock;
        synchronized (object) {
            return this.cardState;
        }
    }

    @Override
    public boolean isContactless() {
        return this.getAtr().isContactless();
    }

    public Object removeAttribute(Object key) {
        return this.attributeMap.removeAttribute(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConnection(CommonCardConnection connection) throws CardException {
        Object object = this.lock;
        synchronized (object) {
            this.connections.remove(connection);
        }
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributeMap.setAttribute(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(EnumCardState newState) {
        EnumCardState oldState;
        Object object = this.lock;
        synchronized (object) {
            if (this.cardState == EnumCardState.INVALID) {
                return;
            }
            if (this.cardState == newState) {
                return;
            }
            oldState = this.cardState;
            this.cardState = newState;
        }
        this.basicGetCardTerminal().triggerCardEvent(this, oldState, newState);
    }

    public String toString() {
        return "card " + this.id;
    }

    public class ConnectTask
    extends AbstractFutureTask<ICardConnection> {
        private final ScheduledExecutorService executor;
        private final String suffix;
        private final int protocol;
        private CommonCardConnection connection;

        protected ConnectTask(String suffix, int protocol, ScheduledExecutorService executor) {
            this.suffix = suffix;
            this.protocol = protocol;
            this.executor = executor;
            this.created();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ICardConnection compute() throws Exception {
            Object object = CommonCard.this.lock;
            synchronized (object) {
                CommonCard.this.checkValidity();
            }
            Log.trace("{} {} connect shared", (Object)this.getLabel(), (Object)CommonCard.this);
            this.connection = CommonCard.this.basicConnectShared(this.suffix, this.protocol, this.executor);
            CommonCard.this.addConnection(this.connection);
            return this.connection;
        }

        protected void taskFailed() {
            if (this.connection != null) {
                try {
                    this.connection.close(0);
                }
                catch (CardException cardException) {
                    // empty catch block
                }
            }
            this.executor.shutdown();
            Log.debug("{} {} connect {}", new Object[]{this.getLabel(), CommonCard.this, this.isCancelled() ? "canceled" : "failed"});
            super.taskFailed();
        }

        protected void undo() {
            ICardConnection temp = (ICardConnection)this.basicGetResult();
            if (temp == null) {
                return;
            }
            try {
                temp.close(0);
            }
            catch (CardException e) {
                Log.trace("{} {} close failed ({})", new Object[]{this.getLabel(), temp, ExceptionTools.getMessage((Throwable)e)});
            }
        }
    }
}

