/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.card;

import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.CardReset;
import de.intarsys.security.smartcard.card.CommonCard;
import de.intarsys.security.smartcard.card.CommonCardTerminal;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.pcsc.PCSCAttribute;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.concurrent.AbstractFutureTask;
import de.intarsys.tools.concurrent.ITaskCallback;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.system.SystemTools;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonCardConnection
implements ICardConnection {
    public static boolean DEBUG = SystemTools.isDebug((String)"pcsc");
    protected static final int PCSC_TRANSACTION_TIMEOUT = 1000;
    private static final Logger Log = LoggerFactory.getLogger(CommonCardConnection.class);
    private final AttributeMap attributes = new AttributeMap();
    private boolean transactionActive = false;
    private long touched;
    private int keepAliveCount = 0;
    private final String id;
    private final ScheduledExecutorService executor;
    private final ScheduledExecutorService keepAliveExecutor;
    protected boolean closed = false;
    private final CommonCard card;
    private final boolean exclusive;
    private final CommonCardTerminal cardTerminal;
    protected final Object lock = new Object();
    private final Runnable runKeepAlive = new Runnable(){

        @Override
        public void run() {
            CommonCardConnection.this.keepAlive();
        }
    };

    protected CommonCardConnection(CommonCard card, String suffix, ScheduledExecutorService executorTask, boolean exclusive) {
        this.card = card;
        this.id = card.getId() + "-" + suffix;
        this.cardTerminal = card.basicGetCardTerminal();
        this.executor = executorTask;
        this.keepAliveExecutor = DEBUG ? new ScheduledThreadPoolExecutor(1) : this.executor;
        this.exclusive = exclusive;
    }

    protected CommonCardConnection(CommonCardTerminal cardTerminal, String suffix, ScheduledExecutorService executorTask, boolean exclusive) {
        this.card = null;
        this.cardTerminal = cardTerminal;
        this.id = cardTerminal.getId() + "-*-" + suffix;
        this.executor = executorTask;
        this.keepAliveExecutor = DEBUG ? new ScheduledThreadPoolExecutor(1) : this.executor;
        this.exclusive = exclusive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void basicBeginTransaction() throws CardException {
        Object object = this.lock;
        synchronized (object) {
            this.markTouched();
        }
        this.keepAlive();
    }

    protected abstract void basicClose(int var1) throws CardException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void basicCloseFinally(int mode) {
        Object object = this.lock;
        synchronized (object) {
            this.executor.shutdownNow();
        }
    }

    protected abstract byte[] basicControl(int var1, byte[] var2, int var3, int var4, int var5) throws CardException;

    protected abstract byte[] basicControlMapped(int var1, byte[] var2, int var3, int var4, int var5) throws CardException;

    protected abstract void basicEndTransaction() throws CardException;

    protected abstract byte[] basicGetAttrib(int var1) throws CardException;

    protected CommonCard basicGetCard() {
        return this.card;
    }

    protected CommonCardTerminal basicGetCardTerminal() {
        return this.cardTerminal;
    }

    protected void basicGetStatus() throws CardException {
    }

    protected abstract void basicReconnect(int var1) throws CardException;

    protected abstract ResponseAPDU basicTransmit(RequestAPDU var1) throws CardException;

    @Override
    public Future<Void> beginTransaction(ITaskCallback<Void> callback) {
        if (this.getCard() == null) {
            CompletableFuture<Void> f = new CompletableFuture<Void>();
            f.completeExceptionally(new IllegalStateException("direct connection"));
            return f;
        }
        Log.trace("{} request beginTransaction", (Object)this.getLogLabel());
        BeginTransactionTask transactionTask = new BeginTransactionTask();
        if (callback != null) {
            transactionTask.addTaskCallback(callback);
        }
        this.execute((Runnable)((Object)transactionTask));
        return transactionTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkValidity() throws CardException {
        Object object = this.lock;
        synchronized (object) {
            if (this.basicGetCard() != null) {
                this.basicGetCard().checkValidity();
            } else if (this.basicGetCardTerminal() != null) {
                this.basicGetCardTerminal().checkValidity();
            }
            if (this.closed) {
                throw new CardReset();
            }
        }
    }

    public void close() throws CardException {
        this.close(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(int mode) throws CardException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            if (DEBUG) {
                this.keepAliveExecutor.shutdownNow();
            }
            CloseTask task = new CloseTask(mode);
            this.execute((Runnable)((Object)task));
        }
        Log.trace("{} request close {}", (Object)this.getLogLabel(), (Object)mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] control(int controlCode, byte[] inBuffer, int inBufferOffset, int inBufferLength, int outBufferSize) throws CardException {
        Log.trace("{} control 0x{}", (Object)this.getLogLabel(), (Object)Integer.toHexString(controlCode));
        Object object = this.lock;
        synchronized (object) {
            this.checkValidity();
        }
        return this.basicControl(controlCode, inBuffer, inBufferOffset, inBufferLength, outBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] controlMapped(int controlCode, byte[] inBuffer, int inBufferOffset, int inBufferLength, int outBufferSize) throws CardException {
        Log.trace("{} control mapped 0x{}", (Object)this.getLogLabel(), (Object)Integer.toHexString(controlCode));
        Object object = this.lock;
        synchronized (object) {
            this.checkValidity();
        }
        return this.basicControlMapped(controlCode, inBuffer, inBufferOffset, inBufferLength, outBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endTransaction() throws CardException {
        Log.trace("{} end transaction", (Object)this.getLogLabel());
        Object object = this.lock;
        synchronized (object) {
            if (!this.transactionActive) {
                return;
            }
        }
        try {
            this.checkValidity();
            this.basicEndTransaction();
        }
        finally {
            object = this.lock;
            synchronized (object) {
                this.transactionActive = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Runnable task) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.checkValidity();
                this.executor.execute(task);
            }
            catch (CardException e) {
                task.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getAttrib(int attribId) throws CardException {
        Log.trace("{} get attrib {} ({})", new Object[]{this.getLogLabel(), ClassTools.getConstantName(PCSCAttribute.class, (Object)attribId), attribId});
        Object object = this.lock;
        synchronized (object) {
            this.checkValidity();
        }
        return this.basicGetAttrib(attribId);
    }

    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    @Override
    public ICard getCard() {
        return this.card;
    }

    @Override
    public ICardTerminal getCardTerminal() {
        return this.cardTerminal;
    }

    public String getId() {
        return this.id;
    }

    protected String getLogLabel() {
        return "connection " + this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getStatus() throws CardException {
        Object object = this.lock;
        synchronized (object) {
            this.checkValidity();
        }
        this.basicGetStatus();
    }

    private long getTouched() {
        return this.touched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTransactionActive() {
        Object object = this.lock;
        synchronized (object) {
            return !this.closed && this.transactionActive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return false;
            }
            if (this.getCard() != null && this.getCard().getState().isInvalid()) {
                return false;
            }
            return this.getCardTerminal() == null || !this.getCardTerminal().isDisposed();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keepAlive() {
        try {
            long idle = 0L;
            Object object = this.lock;
            synchronized (object) {
                if (!this.isTransactionActive()) {
                    return;
                }
                long now = System.currentTimeMillis();
                idle = now - this.getTouched();
            }
            if (idle >= 1000L) {
                idle = 0L;
                ++this.keepAliveCount;
                this.getStatus();
            }
            this.keepAliveExecutor.schedule(this.runKeepAlive, 1000L - idle, TimeUnit.MILLISECONDS);
        }
        catch (CardException e) {
            Log.error("{} PSCS transaction alive check no. {} failed ({})", new Object[]{this.getLogLabel(), this.keepAliveCount, ExceptionTools.getMessage((Throwable)e)});
            try {
                this.close();
            }
            catch (CardException cardException) {
                // empty catch block
            }
        }
    }

    private void markTouched() {
        this.keepAliveCount = 0;
        this.touched = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconnect(int mode) throws CardException {
        Log.trace("{} reconnect connection", (Object)this.getLogLabel());
        Object object = this.lock;
        synchronized (object) {
            this.checkValidity();
        }
        this.basicReconnect(mode);
    }

    public Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    public String toString() {
        return this.getLogLabel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseAPDU transmit(RequestAPDU request) throws CardException {
        Object object = this.lock;
        synchronized (object) {
            this.checkValidity();
            this.markTouched();
        }
        return this.basicTransmit(request);
    }

    public class BeginTransactionTask
    extends AbstractFutureTask<Void> {
        public BeginTransactionTask() {
            this.created();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void compute() throws Exception {
            CommonCardConnection.this.checkValidity();
            Object object = CommonCardConnection.this.lock;
            synchronized (object) {
                CommonCardConnection.this.transactionActive = true;
            }
            CommonCardConnection.this.basicBeginTransaction();
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void taskFailed() {
            Object object = CommonCardConnection.this.lock;
            synchronized (object) {
                CommonCardConnection.this.transactionActive = false;
            }
            super.taskFailed();
        }

        protected void undo() {
            try {
                CommonCardConnection.this.endTransaction();
            }
            catch (CardException e) {
                Log.trace("{} {} undo for end transaction failed", (Object)this.getLabel(), (Object)CommonCardConnection.this);
            }
        }
    }

    public class CloseTask
    extends AbstractFutureTask<Void> {
        private final int mode;

        public CloseTask(int mode) {
            this.mode = mode;
            this.created();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void compute() throws Exception {
            Object object = CommonCardConnection.this.lock;
            synchronized (object) {
                if (CommonCardConnection.this.closed) {
                    return null;
                }
                CommonCardConnection.this.transactionActive = false;
                CommonCardConnection.this.closed = true;
            }
            if (CommonCardConnection.this.basicGetCard() != null) {
                CommonCardConnection.this.basicGetCard().removeConnection(CommonCardConnection.this);
            }
            CommonCardConnection.this.basicClose(this.mode);
            return null;
        }

        protected void taskFinally() {
            super.taskFinally();
            CommonCardConnection.this.basicCloseFinally(this.mode);
        }
    }
}

