/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.card;

import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.CardReset;
import de.intarsys.security.smartcard.card.CardSystemMonitor;
import de.intarsys.security.smartcard.card.CardTools;
import de.intarsys.security.smartcard.card.CardUnavailable;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.ICardSystem;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.concurrent.ITaskCallback;
import de.intarsys.tools.concurrent.Promise;
import de.intarsys.tools.concurrent.TaskFailed;
import de.intarsys.tools.exception.ExceptionTools;
import java.util.Random;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonCardConnectionMonitor
extends CardSystemMonitor {
    private static final Logger Log = LoggerFactory.getLogger(CommonCardConnectionMonitor.class);
    private final Attribute attrConnection = new Attribute("connection");
    private final Attribute attrDelay = new Attribute("delay");

    public CommonCardConnectionMonitor(ICardSystem cardSystem) {
        super(cardSystem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<ICardConnection> connect(final ICard card) {
        Attribute attribute = this.attrConnection;
        synchronized (attribute) {
            Object connectionMarker = card.getAttribute(this.attrConnection);
            if (connectionMarker != null) {
                if (connectionMarker instanceof ICardConnection) {
                    if (((ICardConnection)connectionMarker).isValid()) {
                        return Promise.newFailed((Throwable)new IllegalStateException("already connecting/connected"));
                    }
                } else {
                    return Promise.newFailed((Throwable)new IllegalStateException("already connecting/connected"));
                }
            }
            Log.info("{} connect {}...", this.getLogPrefix(), (Object)card);
            Future<ICardConnection> connectTask = CardTools.connectTransacted(card, new ITaskCallback<ICardConnection>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void failed(TaskFailed exception) {
                    boolean retry;
                    Attribute attribute = CommonCardConnectionMonitor.this.attrConnection;
                    synchronized (attribute) {
                        card.setAttribute(CommonCardConnectionMonitor.this.attrConnection, null);
                    }
                    boolean bl = retry = CommonCardConnectionMonitor.this.isStarted() && CardTools.isRetry(card, (Throwable)exception, 2);
                    if (retry) {
                        Log.info("{} connect {} failed ({}), retry", new Object[]{CommonCardConnectionMonitor.this.getLogPrefix(), card, ExceptionTools.getMessage((Throwable)exception)});
                        CommonCardConnectionMonitor.this.connectLater(card);
                    } else {
                        Log.info("{} connect {} failed", new Object[]{CommonCardConnectionMonitor.this.getLogPrefix(), card, exception});
                        CommonCardConnectionMonitor.this.onConnectionFailed(card, exception);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void finished(final ICardConnection connection) {
                    Attribute attribute = CommonCardConnectionMonitor.this.attrConnection;
                    synchronized (attribute) {
                        card.setAttribute(CommonCardConnectionMonitor.this.attrConnection, connection);
                    }
                    Log.info("{} connect {} success", CommonCardConnectionMonitor.this.getLogPrefix(), (Object)connection);
                    CardTools.resetRetry(card);
                    if (!CommonCardConnectionMonitor.this.isStarted()) {
                        CommonCardConnectionMonitor.this.doClose(connection);
                        return;
                    }
                    CommonCardConnectionMonitor.this.getEventExecutor().submit(new Runnable(){

                        @Override
                        public void run() {
                            if (CommonCardConnectionMonitor.this.isStarted()) {
                                try {
                                    CommonCardConnectionMonitor.this.onConnected(connection);
                                    card.setAttribute(CommonCardConnectionMonitor.this.attrDelay, null);
                                    return;
                                }
                                catch (CardReset e) {
                                    Log.info("{} connect {} reset, retry", CommonCardConnectionMonitor.this.getLogPrefix(), (Object)connection);
                                    CommonCardConnectionMonitor.this.connectLater(card);
                                }
                                catch (CardUnavailable e) {
                                    Log.info("{} connect {} removed", CommonCardConnectionMonitor.this.getLogPrefix(), (Object)connection);
                                }
                                catch (Exception e) {
                                    Log.warn("{} connect {} exception", new Object[]{CommonCardConnectionMonitor.this.getLogPrefix(), connection, e});
                                }
                                CommonCardConnectionMonitor.this.onConnectedGiveup(connection);
                            }
                            CommonCardConnectionMonitor.this.doClose(connection);
                        }
                    });
                }
            });
            card.setAttribute(this.attrConnection, connectTask);
            return connectTask;
        }
    }

    public void connectLater(final ICard card) {
        if (!this.isStarted()) {
            return;
        }
        Long delay = (Long)card.getAttribute(this.attrDelay);
        if (delay == null) {
            delay = 1000L + (long)new Random().nextInt(1000);
        } else if (delay <= 20000L) {
            delay = delay * 2L;
        }
        card.setAttribute(this.attrDelay, delay);
        Log.info("{} schedule {} for re-connection in {} ms", new Object[]{this, card, delay});
        this.getEventExecutor().schedule(new Runnable(){

            @Override
            public void run() {
                if (!card.getState().isInvalid()) {
                    CommonCardConnectionMonitor.this.connect(card);
                }
            }
        }, (long)delay, TimeUnit.MILLISECONDS);
    }

    protected void doClose(ICardConnection connection) {
        try {
            connection.close(0);
        }
        catch (CardException e) {
            Log.trace("{} connect {} close unexpected exception", new Object[]{this.getLogPrefix(), connection, ExceptionTools.getMessage((Throwable)e)});
        }
    }

    protected void onConnected(ICardConnection connection) throws CardException {
        this.doClose(connection);
    }

    protected void onConnectedGiveup(ICardConnection connection) {
    }

    protected void onConnectionFailed(ICard card, TaskFailed exception) {
    }
}

