/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.card;

import de.intarsys.security.smartcard.card.ICardSystem;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.security.smartcard.card.standard.StandardCardTerminal;
import de.intarsys.tools.concurrent.ThreadTools;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.DeferredEventDispatcher;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import jakarta.annotation.PreDestroy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonCardSystem
implements ICardSystem {
    private static final Logger Log = LoggerFactory.getLogger(CommonCardSystem.class);
    private static final int POLLING_INTERVAL = 500;
    private final Object lock = new Object();
    private final DeferredEventDispatcher eventDispatcher;
    private ScheduledExecutorService scheduledExecutor;
    private ScheduledFuture<?> scheduledUpdate;
    private boolean disposed = false;
    private boolean enabled = true;
    private final Runnable updateCardTerminalsCall = new Runnable(){

        @Override
        public void run() {
            CommonCardSystem.this.updateCardTerminals();
        }
    };
    private final Map<String, ICardTerminal> cardTerminalMap;

    public CommonCardSystem() {
        this.eventDispatcher = new DeferredEventDispatcher((Object)this);
        this.cardTerminalMap = new HashMap<String, ICardTerminal>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(EventType type, INotificationListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.eventDispatcher.hasListener()) {
                this.eventDispatcher.addNotificationListener(type, listener);
                this.startEventScheduler();
            } else {
                this.eventDispatcher.addNotificationListener(type, listener);
            }
        }
    }

    protected void basicDispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreDestroy
    public void dispose() {
        ICardTerminal[] iCardTerminalArray = this.lock;
        synchronized (this.lock) {
            if (this.disposed) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
            Log.trace("{} dispose", (Object)this);
            this.disposed = true;
            ICardTerminal[] terminals = this.cardTerminalMap.values().toArray(new StandardCardTerminal[this.cardTerminalMap.size()]);
            this.cardTerminalMap.clear();
            this.stopEventScheduler();
            this.basicDispose();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (ICardTerminal terminal : terminals) {
                terminal.dispose();
                this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)"cardTerminals", (Object)terminal, null));
            }
            this.flushEvents();
            return;
        }
    }

    protected void flushEvents() {
        this.eventDispatcher.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICardTerminal getCardTerminal(String name) {
        Object object = this.lock;
        synchronized (object) {
            return this.cardTerminalMap.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICardTerminal[] getCardTerminals() {
        this.updateCardTerminals();
        Object object = this.lock;
        synchronized (object) {
            return this.cardTerminalMap.values().toArray(new ICardTerminal[this.cardTerminalMap.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDisposed() {
        Object object = this.lock;
        synchronized (object) {
            return this.disposed;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(EventType type, INotificationListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.eventDispatcher.removeNotificationListener(type, listener);
            if (!this.eventDispatcher.hasListener()) {
                this.stopEventScheduler();
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected void startEventScheduler() {
        Log.info("{} start terminal monitor", (Object)this);
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(ThreadTools.newThreadFactoryDaemon((String)"CardSystem terminal monitor"));
        this.scheduledUpdate = this.scheduledExecutor.scheduleWithFixedDelay(this.updateCardTerminalsCall, 0L, 500L, TimeUnit.MILLISECONDS);
    }

    protected void stopEventScheduler() {
        Log.debug("{} stop terminal monitor", (Object)this);
        if (this.scheduledUpdate != null) {
            this.scheduledUpdate.cancel(true);
            this.scheduledUpdate = null;
            this.scheduledExecutor.shutdownNow();
        }
    }

    protected void triggerEvent(Event event) {
        this.eventDispatcher.handleEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCardTerminals() {
        try {
            HashMap<String, ICardTerminal> oldTerminals;
            Iterator iterator = this.lock;
            synchronized (iterator) {
                if (this.disposed) {
                    return;
                }
                oldTerminals = new HashMap<String, ICardTerminal>(this.cardTerminalMap);
                HashMap<String, ICardTerminal> newTerminals = new HashMap<String, ICardTerminal>();
                this.updateCardTerminals(oldTerminals, newTerminals);
                for (ICardTerminal terminal : newTerminals.values()) {
                    Log.info("{} add {}", (Object)this, (Object)terminal);
                    this.cardTerminalMap.put(terminal.getName(), terminal);
                    this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)"cardTerminals", null, (Object)terminal));
                }
                for (ICardTerminal terminal : oldTerminals.values()) {
                    Log.info("{} remove {}", (Object)this, (Object)terminal);
                    this.cardTerminalMap.remove(terminal.getName());
                    this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)"cardTerminals", (Object)terminal, null));
                }
            }
            for (ICardTerminal terminal : oldTerminals.values()) {
                terminal.dispose();
            }
            this.flushEvents();
        }
        catch (Exception e) {
            Log.warn("{} update card terminals unexpected exception", (Object)this, (Object)e);
        }
    }

    protected void updateCardTerminals(Map<String, ICardTerminal> oldTerminals, Map<String, ICardTerminal> newTerminals) {
    }
}

