/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.card;

import de.intarsys.security.smartcard.card.CardEvent;
import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.CardTools;
import de.intarsys.security.smartcard.card.CardUnavailable;
import de.intarsys.security.smartcard.card.CommonCard;
import de.intarsys.security.smartcard.card.CommonCardConnection;
import de.intarsys.security.smartcard.card.CommonCardSystem;
import de.intarsys.security.smartcard.card.EnumCardState;
import de.intarsys.security.smartcard.card.EnumCardTerminalState;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonCardTerminal
implements ICardTerminal {
    private static final Logger Log = LoggerFactory.getLogger(CommonCardTerminal.class);
    private final CommonCardSystem cardSystem;
    private EnumCardTerminalState state;
    protected final Object lock = new Object();
    private final EventDispatcher eventDispatcher;
    private final AttributeMap attributes = new AttributeMap();
    private CommonCard card;
    private final String id;
    private final List<Runnable> resourceFinalizers;

    protected CommonCardTerminal(CommonCardSystem cardSystem, String id) throws CardException {
        if (cardSystem == null) {
            throw new CardException("card system required");
        }
        this.id = id;
        this.cardSystem = cardSystem;
        this.resourceFinalizers = new ArrayList<Runnable>(2);
        this.eventDispatcher = new EventDispatcher((Object)this);
        this.state = EnumCardTerminalState.CONNECTED;
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        this.eventDispatcher.addNotificationListener(type, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSecondaryResourceFinalizer(Runnable finalizer) {
        CommonCardTerminal commonCardTerminal = this;
        synchronized (commonCardTerminal) {
            this.resourceFinalizers.add(finalizer);
        }
    }

    protected abstract CommonCardConnection basicConnectDirect(String var1, ScheduledExecutorService var2) throws CardException;

    protected void basicDispose() {
        this.freeSecondaryResources();
    }

    protected CommonCard basicGetCard() {
        return this.card;
    }

    protected void basicSetCard(CommonCard card) {
        this.card = card;
    }

    protected void checkValidity() throws CardException {
        if (this.isDisposed()) {
            throw new CardUnavailable();
        }
    }

    @Override
    public final ICardConnection connectDirect() throws CardException {
        String suffix = CardTools.createId();
        String executorId = this.getId() + "-*-" + suffix;
        ScheduledExecutorService executor = CardTools.createExecutor(executorId);
        return this.basicConnectDirect(suffix, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispose() {
        CommonCard tempCard;
        Object object = this.lock;
        synchronized (object) {
            if (this.state == EnumCardTerminalState.INVALID) {
                return;
            }
            this.state = EnumCardTerminalState.INVALID;
            tempCard = this.card;
            this.card = null;
        }
        if (tempCard != null) {
            tempCard.dispose();
        }
        this.basicDispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeSecondaryResources() {
        ArrayList<Runnable> tempFinalizers;
        CommonCardTerminal commonCardTerminal = this;
        synchronized (commonCardTerminal) {
            tempFinalizers = new ArrayList<Runnable>(this.resourceFinalizers);
            this.resourceFinalizers.clear();
        }
        for (Runnable finalizer : tempFinalizers) {
            finalizer.run();
        }
    }

    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICard getCard() {
        Object object = this.lock;
        synchronized (object) {
            return this.card;
        }
    }

    @Override
    public CommonCardSystem getCardSystem() {
        return this.cardSystem;
    }

    protected EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public String getId() {
        return this.id;
    }

    protected String getLogLabel() {
        return "terminal " + this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnumCardTerminalState getState() {
        Object object = this.lock;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDisposed() {
        Object object = this.lock;
        synchronized (object) {
            return this.state == EnumCardTerminalState.INVALID;
        }
    }

    public Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.eventDispatcher.removeNotificationListener(type, listener);
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    public String toString() {
        return this.getLogLabel();
    }

    protected void triggerCardEvent(ICard card, EnumCardState oldState, EnumCardState newState) {
        CardEvent event = new CardEvent(card, oldState, newState);
        this.triggerEvent(event);
    }

    protected void triggerEvent(Event event) {
        this.getEventDispatcher().triggerEvent(event);
    }
}

