/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.card;

import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.ICardTransmitter;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;

public class CommonCardTransmitter
implements ICardTransmitter {
    private final ICardTransmitter cardTransmitter;

    public CommonCardTransmitter(ICardTransmitter transmitter) {
        this.cardTransmitter = transmitter;
    }

    protected ResponseAPDU basicTransmit(RequestAPDU request) throws CardException {
        RequestAPDU encodedRequest = this.encodeRequest(request);
        ResponseAPDU encodedResponse = this.getCardTransmitter().transmit(encodedRequest);
        return this.decodeResponse(encodedResponse);
    }

    protected ResponseAPDU decodeResponse(ResponseAPDU response) throws CardException {
        return response;
    }

    protected RequestAPDU encodeRequest(RequestAPDU request) throws CardException {
        return request;
    }

    protected RequestAPDU fixLengthExpected(RequestAPDU request, int correctLE) {
        int cla = request.getCla();
        int ins = request.getIns();
        int p1 = request.getP1();
        int p2 = request.getP2();
        byte[] data = request.getData();
        RequestAPDU result = data == null ? new RequestAPDU(cla, ins, p1, p2, correctLE, false) : new RequestAPDU(cla, ins, p1, p2, data, correctLE, false);
        result.setLabel(request.getLabel());
        return result;
    }

    public ICardTransmitter getCardTransmitter() {
        return this.cardTransmitter;
    }

    @Override
    public ResponseAPDU transmit(RequestAPDU request) throws CardException {
        return this.basicTransmit(request);
    }
}

