/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.card;

import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.security.smartcard.card.ICardTerminalFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexCardTerminalFilter
implements ICardTerminalFilter {
    private static final String PATTERN_STRING = "\\s*(\\w*)\\s*[:=]([^;]*);?";
    private static final Pattern PATTERN = Pattern.compile("\\s*(\\w*)\\s*[:=]([^;]*);?");
    private Map<String, Pattern> patterns = new HashMap<String, Pattern>();

    public static RegexCardTerminalFilter create(String definition) {
        RegexCardTerminalFilter filter = new RegexCardTerminalFilter();
        Matcher m = PATTERN.matcher(definition);
        while (m.find()) {
            String key = m.group(1);
            String value = m.group(2);
            filter.addMatch(key, value.trim());
        }
        return filter;
    }

    @Override
    public boolean accept(ICardTerminal terminal) {
        Pattern pattern = this.patterns.get("name");
        return pattern == null || pattern.matcher(terminal.getName()).matches();
    }

    public void addMatch(String key, String regularExpression) {
        this.patterns.put(key, Pattern.compile(regularExpression));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Pattern> entry : this.patterns.entrySet()) {
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue().pattern());
        }
        return sb.toString();
    }
}

