/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.card;

import de.intarsys.tools.hex.HexTools;

public class RequestAPDU {
    public static final byte CLA_CHAINING_FLAG = 16;
    public static final int LE_MAX = 0;
    public static final int LE_NONE = -1;
    private final int cla;
    private final int ins;
    private final int p1;
    private final int p2;
    private final byte[] data;
    private final byte[] bytes;
    private final int le;
    private boolean extendedApdu = false;
    private String label;
    private boolean sensitiveContent = false;
    private boolean chainedRequest = false;

    public RequestAPDU(byte[] bytes) {
        this.bytes = bytes;
        this.cla = 0;
        this.ins = 0;
        this.p1 = 0;
        this.p2 = 0;
        this.data = null;
        this.le = -1;
    }

    public RequestAPDU(int pCla, int pIns, int pP1, int pP2) {
        this(pCla, pIns, pP1, pP2, null, -1, false);
    }

    public RequestAPDU(int pCla, int pIns, int pP1, int pP2, byte[] pData, boolean extended) {
        this(pCla, pIns, pP1, pP2, pData, -1, false);
    }

    public RequestAPDU(int pCla, int pIns, int pP1, int pP2, byte[] pData, int pLe, boolean extended) {
        this.cla = pCla;
        this.ins = pIns;
        this.p1 = pP1;
        this.p2 = pP2;
        this.le = pLe;
        this.data = this.filterEmptyData(pData);
        this.bytes = null;
        this.extendedApdu = extended;
    }

    public RequestAPDU(int pCla, int pIns, int pP1, int pP2, int pLe, boolean extended) {
        this(pCla, pIns, pP1, pP2, null, pLe, false);
    }

    private byte[] filterEmptyData(byte[] pData) {
        if (pData == null || pData.length == 0) {
            return null;
        }
        return pData;
    }

    public byte[] getBytes() {
        if (this.bytes != null) {
            return this.bytes;
        }
        byte[] buffer = new byte[this.getLength()];
        buffer[0] = (byte)this.getCla();
        buffer[1] = (byte)this.getIns();
        buffer[2] = (byte)this.getP1();
        buffer[3] = (byte)this.getP2();
        int index = 4;
        boolean markExtended = true;
        if (this.data != null) {
            if (this.isExtendedApdu()) {
                buffer[index] = 0;
                buffer[index + 1] = (byte)(this.data.length >> 8 & 0xFF);
                buffer[index + 2] = (byte)(this.data.length & 0xFF);
                index += 3;
                markExtended = false;
            } else {
                buffer[index] = (byte)this.data.length;
                ++index;
            }
            System.arraycopy(this.data, 0, buffer, index, this.data.length);
            index += this.data.length;
        }
        if (this.le != -1) {
            if (this.isExtendedApdu()) {
                if (markExtended) {
                    buffer[index] = 0;
                    ++index;
                }
                buffer[index] = (byte)(this.le >> 8 & 0xFF);
                buffer[index + 1] = (byte)(this.le & 0xFF);
            } else {
                buffer[index] = (byte)(this.le & 0xFF);
            }
        }
        return buffer;
    }

    public int getCla() {
        if (this.isChainedRequest()) {
            return this.cla | 0x10;
        }
        return this.cla;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getIns() {
        return this.ins;
    }

    public String getLabel() {
        return this.label;
    }

    public int getLc() {
        return this.data == null ? -1 : this.data.length;
    }

    public int getLe() {
        return this.le;
    }

    public int getLength() {
        if (this.bytes != null) {
            return this.bytes.length;
        }
        int length = 4;
        int lcle_first = 0;
        int lcle_all = 1;
        if (this.isExtendedApdu()) {
            lcle_first = 1;
            lcle_all = 2;
        }
        if (this.data != null) {
            length += this.data.length;
            length += lcle_first;
            lcle_first = 0;
            length += lcle_all;
        }
        if (this.le != -1) {
            length += lcle_first;
            length += lcle_all;
        }
        return length;
    }

    public int getP1() {
        return this.p1;
    }

    public int getP2() {
        return this.p2;
    }

    public int getReceiveLength() {
        if (this.bytes != null) {
            return 4096;
        }
        if (this.le == -1) {
            return 2;
        }
        if (this.le == 0) {
            if (this.isExtendedApdu()) {
                return 4096;
            }
            return 258;
        }
        return this.le + 2;
    }

    public void insertHeader(byte[] destination, int offset) {
        destination[offset + 0] = (byte)this.getCla();
        destination[offset + 1] = (byte)this.getIns();
        destination[offset + 2] = (byte)this.getP1();
        destination[offset + 3] = (byte)this.getP2();
    }

    public boolean isChainedRequest() {
        return this.chainedRequest;
    }

    public boolean isExtendedApdu() {
        return this.extendedApdu || this.data != null && this.data.length > 255 || this.le > 255;
    }

    public boolean isSensitiveContent() {
        return this.sensitiveContent;
    }

    public void setChainedRequest(boolean chainedRequest) {
        this.chainedRequest = chainedRequest;
    }

    public void setExtendedApdu(boolean extendedApdu) {
        this.extendedApdu = extendedApdu;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setSensitiveContent(boolean sensitiveContent) {
        this.sensitiveContent = sensitiveContent;
    }

    public String toString() {
        return HexTools.bytesToHexString((byte[])this.getBytes());
    }
}

