/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.card;

import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.tools.hex.HexTools;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ResponseAPDU {
    private final byte[] bytes;

    public ResponseAPDU(byte[] response) throws CardException {
        assert (response != null);
        if (response.length < 2) {
            throw new CardException("Invalid response received from card reader");
        }
        this.bytes = response;
    }

    public ResponseAPDU(byte[] data, int sw) {
        if (data == null) {
            data = new byte[]{};
        }
        this.bytes = new byte[data.length + 2];
        System.arraycopy(data, 0, this.bytes, 0, data.length);
        this.bytes[data.length] = (byte)(sw >> 8 & 0xFF);
        this.bytes[data.length + 1] = (byte)(sw & 0xFF);
    }

    public ResponseAPDU(byte[] data, int sw1, int sw2) {
        if (data == null) {
            data = new byte[]{};
        }
        this.bytes = new byte[data.length + 2];
        System.arraycopy(data, 0, this.bytes, 0, data.length);
        this.bytes[data.length] = (byte)sw1;
        this.bytes[data.length + 1] = (byte)sw2;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public byte[] getData() {
        byte[] data = new byte[this.bytes.length - 2];
        System.arraycopy(this.bytes, 0, data, 0, data.length);
        return data;
    }

    public int getData(byte[] pBytes, int offset, int length) {
        int count = this.bytes.length - 2;
        if (length < count) {
            count = length;
        }
        System.arraycopy(this.bytes, 0, pBytes, offset, count);
        return count;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes, 0, this.bytes.length - 2);
    }

    public int getSw() {
        return ((this.bytes[this.bytes.length - 2] & 0xFF) << 8) + (this.bytes[this.bytes.length - 1] & 0xFF);
    }

    public int getSw1() {
        return this.bytes[this.bytes.length - 2] & 0xFF;
    }

    public int getSw2() {
        return this.bytes[this.bytes.length - 1] & 0xFF;
    }

    public String getSwString() {
        return "0x" + Integer.toHexString(this.getSw1()) + Integer.toHexString(this.getSw2());
    }

    public boolean hasData() {
        return this.bytes.length > 2;
    }

    public boolean isOk() {
        return this.getSw1() == 144 && this.getSw2() == 0;
    }

    public String toString() {
        return HexTools.bytesToHexString((byte[])this.bytes);
    }
}

