/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.card;

import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.CommonCardTransmitter;
import de.intarsys.security.smartcard.card.ICardTransmitter;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;

public class T0CardTransmitter
extends CommonCardTransmitter {
    protected static final int INS_GET_RESPONSE = 192;
    protected static final int INS_ENVELOPE = 194;

    public T0CardTransmitter(ICardTransmitter transmitter) {
        super(transmitter);
    }

    @Override
    public ResponseAPDU transmit(RequestAPDU request) throws CardException {
        ResponseAPDU response = null;
        T0Request t0Request = new T0Request(request);
        while (!t0Request.isReady()) {
            response = t0Request.transmit();
        }
        return response;
    }

    class T0Request {
        private RequestAPDU request;
        private byte[] bytes;
        private int offset = 0;
        private boolean ready = false;
        private boolean envelope = false;

        public T0Request(RequestAPDU request) {
            this.convert(request);
        }

        protected void convert(RequestAPDU request) {
            this.request = request;
            byte p3 = 0;
            int lc = request.getLc();
            int le = request.getLe();
            if (lc == -1 && le == -1) {
                p3 = 0;
            } else if (lc == -1 && le >= 0) {
                p3 = le <= 256 ? (byte)le : (byte)0;
            } else if (lc >= 0 && le == -1) {
                if (lc < 256) {
                    p3 = (byte)lc;
                } else {
                    this.envelope = true;
                }
            } else if (lc < 256) {
                p3 = (byte)lc;
            } else {
                this.envelope = true;
            }
            int length = 5;
            if (request.getData() != null) {
                length += request.getData().length;
            }
            if (this.envelope) {
                this.bytes = request.getBytes();
            } else {
                this.bytes = new byte[length];
                this.bytes[0] = (byte)request.getCla();
                this.bytes[1] = (byte)request.getIns();
                this.bytes[2] = (byte)request.getP1();
                this.bytes[3] = (byte)request.getP2();
                this.bytes[4] = p3;
                if (request.getData() != null) {
                    System.arraycopy(request.getData(), 0, this.bytes, 5, request.getData().length);
                }
            }
        }

        protected RequestAPDU createRequest() {
            if (this.envelope) {
                int len = Math.min(256, this.bytes.length);
                byte[] chunk = new byte[len];
                System.arraycopy(this.bytes, this.offset, chunk, 0, chunk.length);
                this.offset += len;
                if (this.offset >= this.bytes.length) {
                    this.ready = true;
                }
                return new RequestAPDU(this.request.getCla(), 194, 0, 0, chunk, -1, false);
            }
            this.ready = true;
            return new RequestAPDU(this.bytes);
        }

        public boolean isReady() {
            return this.ready;
        }

        public ResponseAPDU transmit() throws CardException {
            RequestAPDU fixedRequest;
            RequestAPDU tRequest = this.createRequest();
            tRequest.setLabel(this.request.getLabel());
            ResponseAPDU response = T0CardTransmitter.this.basicTransmit(tRequest);
            if (response.getSw() == 36864 && this.request.getLe() > 0 && response.getBytes().length == 2) {
                RequestAPDU getReq = new RequestAPDU(this.request.getCla(), 192, 0, 0, this.request.getLe(), false);
                getReq.setLabel("get response");
                response = T0CardTransmitter.this.basicTransmit(getReq);
            }
            if (response.getSw1() == 108) {
                int le = response.getSw2();
                this.convert(T0CardTransmitter.this.fixLengthExpected(this.request, le));
                this.offset = 0;
                fixedRequest = this.createRequest();
                response = T0CardTransmitter.this.basicTransmit(fixedRequest);
            }
            if (response.getSw1() == 97) {
                int len = response.getSw2();
                fixedRequest = new RequestAPDU(this.request.getCla(), 192, 0, 0, len, false);
                fixedRequest.setLabel("get response");
                response = T0CardTransmitter.this.basicTransmit(fixedRequest);
            }
            return response;
        }
    }
}

