/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.card.standard;

import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.CommonCardConnection;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.card.standard.StandardCard;
import de.intarsys.security.smartcard.card.standard.StandardCardTerminal;
import de.intarsys.security.smartcard.pcsc.IPCSCConnection;
import de.intarsys.security.smartcard.pcsc.PCSCException;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardCardConnection
extends CommonCardConnection {
    private static final Logger Log = LoggerFactory.getLogger(StandardCardConnection.class);
    private final IPCSCConnection pcscConnection;

    protected StandardCardConnection(StandardCard pCard, ScheduledExecutorService executorTask, boolean exclusive, IPCSCConnection pPcscConnection) {
        super(pCard, pPcscConnection.getId(), executorTask, exclusive);
        this.pcscConnection = pPcscConnection;
        Log.debug("{} created for {}", (Object)this, (Object)this.pcscConnection);
    }

    protected StandardCardConnection(StandardCardTerminal pCardTerminal, ScheduledExecutorService executorTask, boolean exclusive, IPCSCConnection pPcscConnection) {
        super(pCardTerminal, pPcscConnection.getId(), executorTask, exclusive);
        this.pcscConnection = pPcscConnection;
        Log.debug("{} created for {}", (Object)this, (Object)this.pcscConnection);
    }

    @Override
    protected void basicBeginTransaction() throws CardException {
        try {
            this.pcscConnection.beginTransaction();
        }
        catch (PCSCException e) {
            throw CardException.create(e);
        }
        super.basicBeginTransaction();
    }

    @Override
    protected void basicClose(int mode) throws CardException {
        try {
            this.pcscConnection.disconnect(mode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.pcscConnection.getContext().dispose();
        }
        catch (PCSCException e) {
            throw CardException.create(e);
        }
    }

    @Override
    protected byte[] basicControl(int controlCode, byte[] inBuffer, int inBufferOffset, int inBufferLength, int outBufferSize) throws CardException {
        try {
            return this.pcscConnection.control(controlCode, inBuffer, inBufferOffset, inBufferLength, outBufferSize);
        }
        catch (PCSCException e) {
            throw CardException.create(e);
        }
    }

    @Override
    protected byte[] basicControlMapped(int controlCode, byte[] inBuffer, int inBufferOffset, int inBufferLength, int outBufferSize) throws CardException {
        try {
            return this.pcscConnection.controlMapped(controlCode, inBuffer, inBufferOffset, inBufferLength, outBufferSize);
        }
        catch (PCSCException e) {
            throw CardException.create(e);
        }
    }

    @Override
    protected void basicEndTransaction() throws CardException {
        try {
            this.pcscConnection.endTransaction(0);
        }
        catch (PCSCException e) {
            throw CardException.create(e);
        }
    }

    @Override
    protected byte[] basicGetAttrib(int attribId) throws CardException {
        try {
            return this.pcscConnection.getAttrib(attribId);
        }
        catch (PCSCException e) {
            throw CardException.create(e);
        }
    }

    @Override
    protected StandardCard basicGetCard() {
        return (StandardCard)super.basicGetCard();
    }

    @Override
    protected void basicGetStatus() throws CardException {
        try {
            this.pcscConnection.getStatus();
        }
        catch (PCSCException e) {
            throw CardException.create(e);
        }
    }

    @Override
    protected void basicReconnect(int mode) throws CardException {
        try {
            this.pcscConnection.reconnect(this.pcscConnection.getShareMode(), this.pcscConnection.getProtocol(), mode);
        }
        catch (PCSCException e) {
            throw CardException.create(e);
        }
    }

    @Override
    protected ResponseAPDU basicTransmit(RequestAPDU request) throws CardException {
        try {
            if (request.getLabel() != null) {
                Log.trace("{} {}", (Object)this.getLogLabel(), (Object)request.getLabel());
            }
            byte[] response = this.pcscConnection.transmit(request.getBytes(), 0, request.getLength(), request.getReceiveLength(), request.isSensitiveContent());
            return new ResponseAPDU(response);
        }
        catch (PCSCException e) {
            throw CardException.create(e);
        }
    }

    public IPCSCConnection getPcscConnection() {
        return this.pcscConnection;
    }

    @Override
    public int getProtocol() {
        return this.pcscConnection.getProtocol();
    }
}

