/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.card.standard;

import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.CommonCardSystem;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.security.smartcard.card.standard.StandardCardTerminal;
import de.intarsys.security.smartcard.pcsc.EmptyContext;
import de.intarsys.security.smartcard.pcsc.IPCSCCardReader;
import de.intarsys.security.smartcard.pcsc.IPCSCContext;
import de.intarsys.security.smartcard.pcsc.IPCSCContextFactory;
import de.intarsys.security.smartcard.pcsc.PCSCContextFactory;
import de.intarsys.security.smartcard.pcsc.PCSCException;
import de.intarsys.tools.exception.ExceptionTools;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardCardSystem
extends CommonCardSystem {
    public static final StandardCardSystem DISABLED = new StandardCardSystem(new EmptyContext());
    private static final Logger Log = LoggerFactory.getLogger(StandardCardSystem.class);
    private Pattern cardTerminalsHide = Pattern.compile(".*datev.*", 2);
    private IPCSCContext pcscContext;
    private final IPCSCContextFactory pcscContextFactory;

    public StandardCardSystem(IPCSCContext context) {
        this.pcscContext = context;
        this.pcscContextFactory = null;
    }

    public StandardCardSystem(IPCSCContextFactory factory) {
        this.pcscContextFactory = factory == null ? PCSCContextFactory.get() : factory;
    }

    @Override
    protected void basicDispose() {
        this.pcscStop();
    }

    protected IPCSCContext getPcscContext() {
        return this.pcscContext;
    }

    private void pcscStart() {
        if (this.pcscContext == null) {
            if (this.isEnabled()) {
                try {
                    this.pcscContext = this.pcscContextFactory.establishContext();
                }
                catch (PCSCException e) {
                    if (e.getErrorCode() != -2146435042) {
                        Log.warn("{} cannot establish PC/SC context ({})", (Object)this, (Object)ExceptionTools.getMessage((Throwable)e));
                    }
                }
                catch (Exception e) {
                    Log.warn("{} cannot establish PC/SC context", (Object)this, (Object)e);
                    this.pcscContext = new EmptyContext();
                }
            } else {
                Log.info("{} PC/SC disabled", (Object)this);
                this.pcscContext = new EmptyContext();
            }
        }
    }

    private void pcscStop() {
        if (this.pcscContext != null) {
            try {
                this.pcscContext.dispose();
                this.pcscContext = null;
            }
            catch (PCSCException pCSCException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isEnabled() != enabled) {
            this.pcscStop();
        }
        super.setEnabled(enabled);
        this.pcscStart();
    }

    public String toString() {
        return "StandardCardSystem";
    }

    @Override
    protected void updateCardTerminals(Map<String, ICardTerminal> oldTerminals, Map<String, ICardTerminal> newTerminals) {
        this.pcscStart();
        if (this.getPcscContext() == null) {
            return;
        }
        List<IPCSCCardReader> pcscReaders = Collections.EMPTY_LIST;
        try {
            pcscReaders = this.getPcscContext().listReaders();
        }
        catch (PCSCException e) {
            Log.warn("{} PC/SC list readers failed ({}) - restart context", (Object)this, (Object)ExceptionTools.getMessage((Throwable)e));
            this.pcscStop();
        }
        for (IPCSCCardReader pcscReader : pcscReaders) {
            ICardTerminal terminal;
            if (this.cardTerminalsHide.matcher(pcscReader.getName()).matches() || (terminal = oldTerminals.remove(pcscReader.getName())) != null && !terminal.isDisposed()) continue;
            try {
                StandardCardTerminal tempTerminal = new StandardCardTerminal(this, pcscReader);
                newTerminals.put(tempTerminal.getName(), tempTerminal);
            }
            catch (CardException e) {
                if (e.getCause() instanceof PCSCException && ((PCSCException)e.getCause()).getErrorCode() == -2146435063) {
                    Log.debug("{} PC/SC unknown reader {} detected", new Object[]{this, pcscReader, e});
                    continue;
                }
                Log.warn("{} PC/SC creating {} failed", new Object[]{this, pcscReader, e});
            }
            catch (Exception e) {
                Log.warn("{} PC/SC creating {} failed", new Object[]{this, pcscReader, e});
            }
        }
    }
}

