/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.card.standard;

import de.intarsys.security.smartcard.card.ATR;
import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.CommonCardConnection;
import de.intarsys.security.smartcard.card.CommonCardTerminal;
import de.intarsys.security.smartcard.card.EnumCardState;
import de.intarsys.security.smartcard.card.standard.StandardCard;
import de.intarsys.security.smartcard.card.standard.StandardCardConnection;
import de.intarsys.security.smartcard.card.standard.StandardCardSystem;
import de.intarsys.security.smartcard.pcsc.IPCSCCardReader;
import de.intarsys.security.smartcard.pcsc.IPCSCConnection;
import de.intarsys.security.smartcard.pcsc.IPCSCContext;
import de.intarsys.security.smartcard.pcsc.PCSCCardReaderState;
import de.intarsys.security.smartcard.pcsc.PCSCException;
import de.intarsys.security.smartcard.pcsc.PCSCStatusMonitor;
import de.intarsys.security.smartcard.pcsc.PCSCTools;
import de.intarsys.tools.event.INotificationSupport;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardCardTerminal
extends CommonCardTerminal
implements INotificationSupport {
    private static final Logger Log = LoggerFactory.getLogger(StandardCardTerminal.class);
    private final PCSCStatusMonitor monitor;
    private final PCSCStatusMonitor.IStatusListener listenStatus = new PCSCStatusMonitor.IStatusListener(){

        @Override
        public void onException(IPCSCCardReader reader, PCSCException e) {
            StandardCardTerminal.this.dispose();
        }

        @Override
        public void onStatusChange(IPCSCCardReader reader, PCSCCardReaderState cardReaderState) {
            StandardCardTerminal.this.updateCardState(cardReaderState);
        }
    };
    private final IPCSCCardReader pcscCardReader;

    public static EnumCardState mapToEnumCardState(PCSCCardReaderState readerState) {
        EnumCardState cardState = null;
        if (readerState.isPresent()) {
            cardState = EnumCardState.NOT_CONNECTED;
            if (readerState.isExclusive()) {
                cardState = EnumCardState.CONNECTED_EXCLUSIVE;
            } else if (readerState.isInUse()) {
                cardState = EnumCardState.CONNECTED_SHARED;
            }
        }
        return cardState;
    }

    protected StandardCardTerminal(StandardCardSystem cardSystem, IPCSCCardReader pcscCardReader) throws CardException {
        super(cardSystem, pcscCardReader.getId());
        PCSCCardReaderState initialState;
        this.pcscCardReader = pcscCardReader;
        try {
            initialState = this.getPcscCardReader().getState();
        }
        catch (PCSCException e) {
            throw CardException.create(e);
        }
        this.updateCardState(initialState);
        this.monitor = new PCSCStatusMonitor(pcscCardReader);
        this.monitor.addStatusListener(this.listenStatus);
        Log.info("{} created for '{}'", (Object)this, (Object)this.getName());
    }

    @Override
    protected CommonCardConnection basicConnectDirect(String suffix, ScheduledExecutorService executor) throws CardException {
        IPCSCContext context = null;
        try {
            context = this.getPcscCardReader().getContext().establishContext(suffix);
            Log.trace("{} create connection context {}", (Object)this.getLogLabel(), (Object)context);
            IPCSCConnection connection = context.connect(suffix, this.getPcscCardReader().getName(), 3, PCSCTools.DirectConnectProtocol);
            StandardCardConnection newChannel = new StandardCardConnection(this, executor, true, connection);
            return newChannel;
        }
        catch (PCSCException e) {
            if (context != null) {
                try {
                    context.dispose();
                }
                catch (PCSCException pCSCException) {
                    // empty catch block
                }
            }
            throw CardException.create(e);
        }
    }

    protected StandardCardConnection basicConnectExclusive(StandardCard card, String suffix, int protocol, ScheduledExecutorService executor) throws CardException {
        IPCSCContext context = null;
        try {
            context = this.getPcscCardReader().getContext().establishContext(suffix);
            Log.trace("{} create connection context {}", (Object)this.getLogLabel(), (Object)context);
            IPCSCConnection pcscConnection = context.connect(suffix, this.getPcscCardReader().getName(), 1, protocol);
            return new StandardCardConnection(card, executor, true, pcscConnection);
        }
        catch (PCSCException e) {
            if (context != null) {
                try {
                    context.dispose();
                }
                catch (PCSCException pCSCException) {
                    // empty catch block
                }
            }
            throw CardException.create(e);
        }
    }

    protected StandardCardConnection basicConnectShared(StandardCard card, String suffix, int protocol, ScheduledExecutorService executor) throws CardException {
        IPCSCContext context = null;
        try {
            context = this.getPcscCardReader().getContext().establishContext(suffix);
            Log.trace("{} create connection context {}", (Object)this.getLogLabel(), (Object)context);
            IPCSCConnection pcscConnection = context.connect(suffix, this.getPcscCardReader().getName(), 2, protocol);
            return new StandardCardConnection(card, executor, false, pcscConnection);
        }
        catch (PCSCException e) {
            if (context != null) {
                try {
                    context.dispose();
                }
                catch (PCSCException pCSCException) {
                    // empty catch block
                }
            }
            throw CardException.create(e);
        }
    }

    @Override
    protected void basicDispose() {
        super.basicDispose();
        this.monitor.removeStatusListener(this.listenStatus);
    }

    @Override
    public String getName() {
        return this.getPcscCardReader().getName();
    }

    protected IPCSCCardReader getPcscCardReader() {
        return this.pcscCardReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renew() {
        EnumCardState cardState = null;
        StandardCard tempCard = null;
        StandardCard newCard = null;
        Object object = this.lock;
        synchronized (object) {
            tempCard = (StandardCard)this.basicGetCard();
            if (tempCard == null) {
                return;
            }
            cardState = tempCard.getState();
            ATR atr = tempCard.getAtr();
            newCard = new StandardCard(this, atr);
            this.basicSetCard(newCard);
        }
        tempCard.dispose();
        newCard.setState(cardState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCardState(PCSCCardReaderState newReaderState) {
        EnumCardState cardState = StandardCardTerminal.mapToEnumCardState(newReaderState);
        StandardCard tempCard = null;
        StandardCard invalidCard = null;
        Object object = this.lock;
        synchronized (object) {
            tempCard = (StandardCard)this.basicGetCard();
            if (cardState != null) {
                if (tempCard == null) {
                    ATR atr = ATR.create(newReaderState.getATR());
                    if (atr == null) {
                        Log.debug("{} struct ReaderState does not contain an ATR - event ignored", (Object)this);
                    } else {
                        tempCard = new StandardCard(this, atr);
                    }
                }
            } else if (tempCard != null) {
                invalidCard = tempCard;
                tempCard = null;
            }
            this.basicSetCard(tempCard);
        }
        if (invalidCard != null) {
            invalidCard.dispose();
        }
        if (tempCard != null) {
            tempCard.setState(cardState);
        }
    }
}

