/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pcsc;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.type.NativeLongLP64;
import de.intarsys.nativec.type.NativeString;
import de.intarsys.security.smartcard.pcsc.INativePCSCLib;
import de.intarsys.security.smartcard.pcsc.IPCSCContext;
import de.intarsys.security.smartcard.pcsc.PCSCCardReaderState;
import de.intarsys.security.smartcard.pcsc.PCSCConnection;
import de.intarsys.security.smartcard.pcsc.PCSCException;
import de.intarsys.security.smartcard.pcsc.nativec.SCARDCONTEXT;
import de.intarsys.security.smartcard.pcsc.nativec.SCARD_READERSTATE;
import de.intarsys.security.smartcard.pcsc.nativec._IPCSC;
import de.intarsys.tools.concurrent.ThreadTools;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonPCSCContext
implements IPCSCContext {
    private static final Logger Log = LoggerFactory.getLogger(CommonPCSCContext.class);
    private static final AtomicInteger Counter = new AtomicInteger(0);
    protected SCARDCONTEXT hContext;
    private final _IPCSC pcsc;
    private final INativePCSCLib lib;
    protected final Object lock = new Object();
    protected final Object lockContext = new Object();
    private final String id;
    private boolean useBlockingGetStatusChange;

    protected static SCARDCONTEXT establish(_IPCSC pcsc) throws PCSCException {
        NativeLongLP64 phContext = new NativeLongLP64();
        for (int retry = 0; retry < 3; ++retry) {
            int rc = pcsc.SCardEstablishContext(2L, phContext);
            if (rc != 121) {
                PCSCException.checkReturnCode(rc);
                break;
            }
            ThreadTools.sleep((long)50L);
        }
        SCARDCONTEXT result = new SCARDCONTEXT(phContext.longValue());
        return result;
    }

    protected CommonPCSCContext(INativePCSCLib pLib, String id, _IPCSC pPcsc, SCARDCONTEXT pHContext) {
        this.id = id;
        this.lib = pLib;
        this.pcsc = pPcsc;
        this.hContext = pHContext;
        int count = Counter.incrementAndGet();
        Log.debug("{} created, handle {}, {} active", new Object[]{this.getLogLabel(), Long.toHexString(this.hContext.longValue()), count});
    }

    protected void basicRelease(SCARDCONTEXT pHContext) throws PCSCException {
        int rc = this.pcsc.SCardReleaseContext(pHContext);
        PCSCException.checkReturnCode(rc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() throws PCSCException {
        SCARDCONTEXT tempContext;
        if (this.isReleaseVeto()) {
            Log.warn("{} not released, connection pending", (Object)this.getLogLabel());
            return;
        }
        int count = Counter.decrementAndGet();
        Object object = this.lockContext;
        synchronized (object) {
            if (this.hContext == null) {
                return;
            }
            tempContext = this.hContext;
            this.hContext = null;
        }
        Log.debug("{} release, {} active", (Object)this.getLogLabel(), (Object)count);
        try {
            this.basicRelease(tempContext);
        }
        catch (PCSCException e) {
            Log.debug("{} release exception", (Object)this.getLogLabel(), (Object)e);
        }
    }

    @Override
    public IPCSCContext establishContext(String id) throws PCSCException {
        return this.getLib().establishContext(id);
    }

    protected void fromConnectionBeginTransaction(PCSCConnection connection) throws PCSCException {
        int rc = this.getPcsc().SCardBeginTransaction(connection.getHCard());
        PCSCException.checkReturnCode(rc);
    }

    protected void fromConnectionDisconnect(PCSCConnection connection, long disposition) throws PCSCException {
        int rc = this.getPcsc().SCardDisconnect(connection.getHCard(), disposition);
        try {
            PCSCException.checkReturnCode(rc);
        }
        catch (PCSCException e) {
            if (this.isDisposed()) {
                return;
            }
            throw e;
        }
    }

    protected void fromConnectionEndTransaction(PCSCConnection connection, int disposition) throws PCSCException {
        int rc = this.getPcsc().SCardEndTransaction(connection.getHCard(), disposition);
        try {
            PCSCException.checkReturnCode(rc);
        }
        catch (PCSCException e) {
            if (this.isDisposed()) {
                return;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SCARDCONTEXT getHContext() {
        Object object = this.lockContext;
        synchronized (object) {
            return this.hContext;
        }
    }

    public String getId() {
        return this.id;
    }

    public INativePCSCLib getLib() {
        return this.lib;
    }

    protected String getLogLabel() {
        return "PCSCContext " + this.getId();
    }

    public _IPCSC getPcsc() {
        return this.pcsc;
    }

    protected INativeHandle getProtocolHandle(int protocolId) {
        switch (protocolId) {
            case 1: {
                return this.getPcsc().getSCARD_PCI_T0();
            }
            case 2: {
                return this.getPcsc().getSCARD_PCI_T1();
            }
        }
        return null;
    }

    protected abstract void getStatusChange(SCARD_READERSTATE var1, int var2) throws PCSCException;

    @Override
    public final PCSCCardReaderState getStatusChange(String readerName, PCSCCardReaderState currentState, int millisecTimeout) throws PCSCException, TimeoutException {
        SCARD_READERSTATE newState = new SCARD_READERSTATE();
        newState.setReader(new NativeString(readerName));
        if (currentState != null) {
            newState.setCurrentState(currentState.getEventState());
            newState.setEventState(currentState.getEventState());
            newState.setATR(currentState.getATR());
        } else {
            newState.setCurrentState(0);
            newState.setEventState(0);
        }
        try {
            Log.trace("{} getStatusChange({}), blocking={}", new Object[]{this.getLogLabel(), readerName, this.isUseBlockingGetStatusChange()});
            this.getStatusChange(newState, millisecTimeout);
            PCSCCardReaderState state = new PCSCCardReaderState(newState);
            Log.trace("{} getStatusChange(), -> \n{}", (Object)this.getLogLabel(), (Object)state.toString());
            return state;
        }
        catch (PCSCException e) {
            if (e.getErrorCode() == -2146435062) {
                Log.trace("{} getStatusChange({}) timeout", (Object)this.getLogLabel(), (Object)readerName);
                throw new TimeoutException(e.getLocalizedMessage());
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDisposed() {
        Object object = this.lockContext;
        synchronized (object) {
            return this.hContext == null;
        }
    }

    protected boolean isReleaseVeto() {
        return false;
    }

    public boolean isUseBlockingGetStatusChange() {
        return this.useBlockingGetStatusChange;
    }

    public void setUseBlockingGetStatusChange(boolean useBlockingGetStatusChange) {
        this.useBlockingGetStatusChange = useBlockingGetStatusChange;
    }

    public String toString() {
        return this.getLogLabel();
    }
}

