/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pcsc;

import de.intarsys.security.smartcard.pcsc.INativePCSCLib;
import de.intarsys.security.smartcard.pcsc.NativePCSCContextFactory;
import de.intarsys.security.smartcard.pcsc.nativec._IPCSC;
import de.intarsys.security.smartcard.pcsc.nativec._PCSC;
import de.intarsys.security.smartcard.pcsc.nativec._PCSCThreadedExecutor;
import de.intarsys.tools.system.SystemTools;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonPCSCLib
implements INativePCSCLib {
    private static final Logger Log = LoggerFactory.getLogger(CommonPCSCLib.class);
    private _IPCSC pcsc;
    private String path;
    private boolean useExecutorThread = false;
    private boolean useBlockingGetStatusChange = SystemTools.isWindows();

    protected void createNativeWrapper() {
        try {
            _PCSC nativeWrapper = new _PCSC(this.path);
            this.pcsc = this.useExecutorThread ? new _PCSCThreadedExecutor(nativeWrapper) : nativeWrapper;
        }
        catch (Throwable t) {
            Log.warn("No PC/SC interface available: {}\n{}", (Object)t.getMessage(), (Object)t);
        }
    }

    public String getPath() {
        return this.path;
    }

    public _IPCSC getPcsc() {
        return this.pcsc;
    }

    @PostConstruct
    public void initialize() {
        this.createNativeWrapper();
        NativePCSCContextFactory.get().registerLibrary(this);
    }

    public boolean isUseBlockingGetStatusChange() {
        return this.useBlockingGetStatusChange;
    }

    public boolean isUseExecutorThread() {
        return this.useExecutorThread;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setUseBlockingGetStatusChange(boolean useBlockingGetStatusChange) {
        this.useBlockingGetStatusChange = useBlockingGetStatusChange;
    }

    public void setUseExecutorThread(boolean useExecutorThread) {
        this.useExecutorThread = useExecutorThread;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PC/SC library; path ");
        sb.append(this.getPath());
        sb.append("; executor ");
        sb.append(this.isUseExecutorThread());
        sb.append("; blocking ");
        sb.append(this.isUseBlockingGetStatusChange());
        return sb.toString();
    }
}

